/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.Status;
import org.json.JSONObject;

public class Account
extends Entity {
    public Status status;
    public String bankCode;
    public String bankName;
    public String accountType;
    public String accountNumber;

    public Account(JSONObject object) {
        this(object.has("status") ? new Status(object.getJSONObject("status")) : null, object.has("bankCode") ? object.getString("bankCode") : null, object.has("bankName") ? object.getString("bankName") : null, object.has("accountType") ? object.getString("accountType") : null, object.has("accountNumber") ? object.getString("accountNumber") : null);
    }

    public Account(Status status, String bankCode, String bankName, String accountType, String accountNumber) {
        this.status = status;
        this.bankCode = bankCode;
        this.bankName = bankName;
        this.accountType = accountType;
        this.accountNumber = accountNumber;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String franchise() {
        return "_" + this.bankCode + "_";
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        object.put("status", this.status == null ? null : this.status.toJsonObject());
        object.put("bankCode", (Object)this.bankCode);
        object.put("bankName", (Object)this.bankName);
        object.put("accountType", (Object)this.accountType);
        object.put("accountNumber", (Object)this.accountNumber);
        object.put("franchise", (Object)this.franchise());
        return Entity.filterJSONObject(object);
    }

    public String getType() {
        return "account";
    }

    public String franchiseName() {
        return this.bankName;
    }

    public String lastDigits() {
        int length = this.accountNumber.length();
        return this.accountNumber.substring(length - 4);
    }

    public JSONObject toNameValuePairJsonObject() {
        JSONObject object = new JSONObject();
        object.put("bankCode", (Object)this.bankCode);
        object.put("bankName", (Object)this.bankName);
        object.put("accountType", (Object)this.accountType);
        object.put("accountNumber", (Object)this.accountNumber);
        return Entity.filterJSONObject(object);
    }
}

