/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.AmountBase;
import com.placetopay.java_placetopay.Entities.AmountDetail;
import com.placetopay.java_placetopay.Entities.TaxDetail;
import com.placetopay.java_placetopay.Utils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Amount
extends AmountBase {
    protected List<TaxDetail> taxes = null;
    protected List<AmountDetail> details = null;
    protected double taxAmount;
    protected double vatDevolutionBase = 0.0;
    protected double subtotal = 0.0;

    public Amount(JSONObject object) {
        super(object);
        if (object.has("taxes")) {
            this.taxes = this.convertToTaxList(object.get("taxes"));
        }
        if (object.has("details")) {
            this.details = this.convertToAmountList(object.get("details"));
        }
    }

    public Amount(List<TaxDetail> taxes, List<AmountDetail> details, String currency, float total) {
        super(currency, total);
        this.taxes = taxes;
        this.details = details;
    }

    private List<TaxDetail> convertToTaxList(Object json) {
        List<TaxDetail> localDetails = Utils.convertToList(json, "taxes", TaxDetail.class);
        for (TaxDetail item : localDetails) {
            this.taxAmount += (double)item.amount;
        }
        return localDetails;
    }

    private List<AmountDetail> convertToAmountList(Object json) {
        return Utils.convertToList(json, "details", AmountDetail.class);
    }

    public List<TaxDetail> getTaxes() {
        return this.taxes;
    }

    public List<AmountDetail> getDetails() {
        return this.details;
    }

    public double getTaxAmount() {
        return this.taxAmount;
    }

    public double getDevolutionBase() {
        return this.vatDevolutionBase;
    }

    public double getSubtotal() {
        if (this.subtotal == 0.0) {
            return this.total - this.taxAmount;
        }
        return this.subtotal;
    }

    public void setVatDevolutionBase(float vatDevolutionBase) {
        this.vatDevolutionBase = vatDevolutionBase;
    }

    public void setSubtotal(float subtotal) {
        this.subtotal = subtotal;
    }

    public JSONArray taxesToJsonArray() {
        if (this.taxes != null) {
            JSONArray array = new JSONArray();
            for (TaxDetail tax : this.taxes) {
                array.put((Object)tax.toJsonObject());
            }
        }
        return null;
    }

    public JSONArray detailsToJsonArray() {
        if (this.details != null) {
            JSONArray array = new JSONArray();
            for (AmountDetail amount : this.details) {
                array.put((Object)amount.toJsonObject());
            }
        }
        return null;
    }

    @Override
    public JSONObject toJsonObject() {
        JSONArray detailsArray;
        JSONObject object = super.toJsonObject();
        JSONArray taxesArray = this.taxesToJsonArray();
        if (taxesArray != null) {
            object.put("taxes", (Object)taxesArray);
        }
        if ((detailsArray = this.detailsToJsonArray()) != null) {
            object.put("details", this.details);
        }
        return Entity.filterJSONObject(object);
    }
}

