/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.NameValuePair;
import com.placetopay.java_placetopay.Interfaces.HasFields;
import com.placetopay.java_placetopay.Utils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class EntityWithNameValuePair
extends Entity
implements HasFields {
    protected final List<NameValuePair> fields;

    public EntityWithNameValuePair(JSONObject object) {
        this.fields = object.has("fields") ? EntityWithNameValuePair.getFieldsFromJsonArray(object.get("fields")) : new ArrayList();
    }

    public EntityWithNameValuePair() {
        this.fields = new ArrayList<NameValuePair>();
    }

    public EntityWithNameValuePair(List<NameValuePair> fields) {
        this.fields = fields;
    }

    @Override
    public List<NameValuePair> getFields() {
        return this.fields;
    }

    @Override
    public void addFields(List<NameValuePair> pairs) {
        this.fields.addAll(pairs);
    }

    @Override
    public void addField(String key, String value) {
        this.fields.add(new NameValuePair(key, value));
    }

    @Override
    public void addField(String key, String value, String displayOn) {
        this.fields.add(new NameValuePair(key, value, displayOn));
    }

    @Override
    public JSONArray fieldsToArrayObject() {
        JSONArray arrayFields = new JSONArray();
        for (NameValuePair field : this.fields) {
            arrayFields.put((Object)field.toJsonObject());
        }
        return arrayFields;
    }

    @Override
    public JSONArray fieldsToKeyValueArrayObject() {
        JSONArray arrayFields = new JSONArray();
        for (NameValuePair field : this.fields) {
            JSONObject object = new JSONObject();
            object.put("keyword", (Object)field.keyword);
            object.put("value", (Object)field.value);
            arrayFields.put((Object)object);
        }
        return arrayFields;
    }

    private static List<NameValuePair> getFieldsFromJsonArray(Object json) {
        return Utils.convertToList(json, "fields", NameValuePair.class);
    }
}

