/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities.Models;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.EntityWithNameValuePair;
import com.placetopay.java_placetopay.Entities.Instrument;
import com.placetopay.java_placetopay.Entities.Payment;
import com.placetopay.java_placetopay.Entities.Person;
import org.json.JSONObject;

public class CollectRequest
extends EntityWithNameValuePair {
    protected String locale = "es_CO";
    protected Person payer;
    protected Person buyer;
    protected Payment payment;
    protected Instrument instrument;

    public CollectRequest(String content) {
        this(new JSONObject(content));
    }

    public CollectRequest(JSONObject object) {
        super(object);
        this.payer = object.has("payer") ? new Person(object.getJSONObject("payer")) : null;
        this.buyer = object.has("buyer") ? new Person(object.getJSONObject("buyer")) : null;
        this.payment = object.has("payment") ? new Payment(object.getJSONObject("payment")) : null;
        Instrument instrument = this.instrument = object.has("instrument") ? new Instrument(object.getJSONObject("instrument")) : null;
        if (object.has("locale")) {
            this.locale = object.getString("locale");
        }
    }

    public CollectRequest(Person payer, Person buyer, Payment payment, Instrument instrument) {
        this.payer = payer;
        this.buyer = buyer;
        this.payment = payment;
        this.instrument = instrument;
    }

    public CollectRequest(String locale, Person payer, Person buyer, Payment payment, Instrument instrument) {
        this.locale = locale;
        this.payer = payer;
        this.buyer = buyer;
        this.payment = payment;
        this.instrument = instrument;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setPayer(Person payer) {
        this.payer = payer;
    }

    public void setBuyer(Person buyer) {
        this.buyer = buyer;
    }

    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public String language() {
        return this.locale.substring(0, 2).toUpperCase();
    }

    public String getLocale() {
        return this.locale;
    }

    public Person getPayer() {
        return this.payer;
    }

    public Person getBuyer() {
        return this.buyer;
    }

    public Payment getPayment() {
        return this.payment;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public String getReference() {
        return this.payment.getReference();
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        object.put("locale", (Object)this.locale);
        object.put("payer", this.payer == null ? null : this.payer.toJsonObject());
        object.put("buyer", this.buyer == null ? null : this.buyer.toJsonObject());
        object.put("payment", this.payment == null ? null : this.payment.toJsonObject());
        object.put("instrument", this.instrument == null ? null : this.instrument.toJsonObject());
        object.put("fields", (Object)this.fieldsToArrayObject());
        return Entity.filterJSONObject(object);
    }
}

