/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities.Models;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.Status;
import com.placetopay.java_placetopay.Exceptions.BadPlaceToPayException;
import com.placetopay.java_placetopay.Exceptions.PlaceToPayException;
import com.placetopay.java_placetopay.Interfaces.HasStatus;
import com.placetopay.java_placetopay.Utils;
import java.security.NoSuchAlgorithmException;
import org.json.JSONException;
import org.json.JSONObject;

public class Notification
extends Entity
implements HasStatus {
    protected Status status;
    protected final Integer requestId;
    protected final String reference;
    protected final String signature;
    private String tranKey;

    public Notification(Status status, Integer requestId, String reference, String signature, String tranKey) {
        this.status = status;
        this.requestId = requestId;
        this.reference = reference;
        this.signature = signature;
        this.tranKey = tranKey;
    }

    public Notification(String content, String tranKey) throws BadPlaceToPayException {
        try {
            JSONObject object = new JSONObject(content);
            this.status = new Status(object.getJSONObject("status"));
            this.requestId = object.getInt("requestId");
            this.reference = object.getString("reference");
            this.signature = object.getString("signature");
            this.tranKey = tranKey;
        }
        catch (JSONException ex) {
            throw new BadPlaceToPayException(ex.getMessage());
        }
    }

    public Notification(JSONObject object, String tranKey) throws BadPlaceToPayException {
        this.status = new Status(object.getJSONObject("status"));
        this.requestId = object.getInt("requestId");
        this.reference = object.getString("reference");
        this.signature = object.getString("signature");
        this.tranKey = tranKey;
    }

    public Integer getRequestId() {
        return this.requestId;
    }

    public String getReference() {
        return this.reference;
    }

    public String getSignature() {
        return this.signature;
    }

    @Override
    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public String makeSignature() {
        try {
            return Utils.byteArrayToHexString(Utils.sha1(this.requestId + this.status.getStatus() + this.status.getDate() + this.tranKey));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PlaceToPayException(ex.getMessage());
        }
    }

    public boolean isValidNotification() {
        return this.signature.equals(this.makeSignature());
    }

    public boolean isApproved() {
        return this.status.getStatus().equals("APPROVED");
    }

    public boolean isRejected() {
        return this.status.getStatus().equals("REJECTED");
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        object.put("status", this.status != null ? this.status.toJsonObject() : null);
        object.put("requestId", (Object)this.requestId);
        object.put("reference", (Object)this.reference);
        object.put("signature", (Object)this.signature);
        return object;
    }
}

