/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities.Models;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.Models.RedirectRequest;
import com.placetopay.java_placetopay.Entities.Status;
import com.placetopay.java_placetopay.Entities.SubscriptionInformation;
import com.placetopay.java_placetopay.Entities.Transaction;
import com.placetopay.java_placetopay.Interfaces.HasStatus;
import com.placetopay.java_placetopay.Utils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class RedirectInformation
extends Entity
implements HasStatus {
    public Integer requestId;
    public RedirectRequest request;
    public List<Transaction> payment;
    public SubscriptionInformation subscription;
    protected Status status;

    public RedirectInformation(Status status) {
        this.status = status;
    }

    public RedirectInformation(JSONObject object) {
        this.requestId = object.has("requestId") ? Integer.valueOf(object.getInt("requestId")) : null;
        this.request = object.has("request") ? new RedirectRequest(object.getJSONObject("request")) : null;
        this.payment = object.has("payment") ? this.paymentFromJsonArray(object.get("payment")) : null;
        this.subscription = object.has("subscription") ? new SubscriptionInformation(object.getJSONObject("subscription")) : null;
        this.status = object.has("status") ? new Status(object.getJSONObject("status")) : null;
    }

    public RedirectInformation(Integer requestId, RedirectRequest request, List<Transaction> payment, SubscriptionInformation subscription, Status status) {
        this.requestId = requestId;
        this.request = request;
        this.payment = payment;
        this.subscription = subscription;
        this.status = status;
    }

    public RedirectInformation(String content) {
        this(new JSONObject(content));
    }

    @Override
    public void setStatus(Status status) {
        this.status = status;
    }

    public void setRequestId(Integer requestId) {
        this.requestId = requestId;
    }

    public void setRequest(RedirectRequest request) {
        this.request = request;
    }

    public void setPayment(List<Transaction> payment) {
        this.payment = payment;
    }

    public void setSubscription(SubscriptionInformation subscription) {
        this.subscription = subscription;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public Integer getRequestId() {
        return this.requestId;
    }

    public RedirectRequest getRequest() {
        return this.request;
    }

    public List<Transaction> getPayment() {
        return this.payment;
    }

    public SubscriptionInformation getSubscription() {
        return this.subscription;
    }

    private List<Transaction> paymentFromJsonArray(Object object) {
        return Utils.convertToList(object, "transaction", Transaction.class);
    }

    private JSONArray paymentToJsonArray() {
        JSONArray array = new JSONArray();
        for (Transaction transaction : this.payment) {
            array.put((Object)transaction.toJsonObject());
        }
        return array;
    }

    public boolean isSuccessful() {
        return !this.status.getStatus().equals("ERROR");
    }

    public boolean isApproved() {
        return this.status.getStatus().equals("APPROVED");
    }

    public Transaction lastApprovedTransaction() {
        return this.lastTransaction(true);
    }

    public Transaction lastTransaction() {
        return this.lastTransaction(false);
    }

    public Transaction lastTransaction(boolean approved) {
        List<Transaction> transactions = this.payment;
        if (transactions != null && transactions.size() > 0) {
            if (approved) {
                for (int i = 0; i < transactions.size(); ++i) {
                    Transaction transaction = transactions.get(i);
                    if (!transaction.isApproved()) continue;
                    return transaction;
                }
            } else {
                return transactions.get(0);
            }
        }
        return null;
    }

    public String lastAuthorization() {
        Transaction lastApprovedTransaction = this.lastApprovedTransaction();
        if (lastApprovedTransaction != null) {
            return lastApprovedTransaction.getAuthorization();
        }
        return null;
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        object.put("requestId", (Object)this.requestId);
        object.put("status", this.status == null ? null : this.status.toJsonObject());
        object.put("request", this.request == null ? null : this.request.toJsonObject());
        object.put("payment", (Object)(this.payment == null ? null : this.paymentToJsonArray()));
        object.put("subscription", this.subscription == null ? null : this.subscription.toJsonObject());
        return Entity.filterJSONObject(object);
    }
}

