/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities.Models;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.EntityWithNameValuePair;
import com.placetopay.java_placetopay.Entities.Payment;
import com.placetopay.java_placetopay.Entities.Person;
import com.placetopay.java_placetopay.Entities.Subscription;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.json.JSONObject;

public class RedirectRequest
extends EntityWithNameValuePair {
    protected String locale = "es_CO";
    protected Person payer;
    protected Person buyer;
    protected Payment payment;
    protected Subscription subscription;
    protected String returnUrl;
    protected String paymentMethod;
    protected String cancelUrl;
    protected String ipAddress;
    protected String userAgent;
    protected String expiration;
    protected boolean captureAddress;
    protected boolean skipResult = false;
    protected boolean noBuyerFill = false;

    public RedirectRequest(JSONObject object) {
        super(object);
        this.payer = object.has("payer") ? new Person(object.getJSONObject("payer")) : null;
        this.buyer = object.has("buyer") ? new Person(object.getJSONObject("buyer")) : null;
        this.payment = object.has("payment") ? new Payment(object.getJSONObject("payment")) : null;
        this.subscription = object.has("subscription") ? new Subscription(object.getJSONObject("subscription")) : null;
        this.userAgent = object.has("userAgent") ? object.getString("userAgent") : null;
        this.ipAddress = object.has("ipAddress") ? object.getString("ipAddress") : null;
        this.returnUrl = object.has("returnUrl") ? object.getString("returnUrl") : null;
        this.paymentMethod = object.has("paymentMethod") ? object.getString("paymentMethod") : null;
        this.cancelUrl = object.has("cancelUrl") ? object.getString("cancelUrl") : null;
        this.captureAddress = object.has("captureAddress") ? object.getBoolean("captureAddress") : false;
        this.skipResult = object.has("skipResult") ? object.getBoolean("skipResult") : false;
        boolean bl = this.noBuyerFill = object.has("noBuyerFill") ? object.getBoolean("noBuyerFill") : false;
        if (object.has("locale")) {
            this.locale = object.getString("locale");
        }
        if (object.has("expiration")) {
            this.expiration = object.getString("expiration");
        } else {
            Date dt = new Date();
            Calendar c = Calendar.getInstance();
            c.setTime(dt);
            c.add(5, 1);
            dt = c.getTime();
            this.expiration = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(dt);
        }
    }

    public RedirectRequest(Person payer, Person buyer, Payment payment, String returnUrl, String paymentMethod) {
        this.payer = payer;
        this.buyer = buyer;
        this.payment = payment;
        this.returnUrl = returnUrl;
        this.paymentMethod = paymentMethod;
    }

    public RedirectRequest(Person payer, Person buyer, Payment payment, Subscription subscription, String returnUrl, String paymentMethod, String cancelUrl, String ipAddress, String userAgent, String expiration, boolean captureAddress, boolean noBuyerFill) {
        this.payer = payer;
        this.buyer = buyer;
        this.payment = payment;
        this.subscription = subscription;
        this.returnUrl = returnUrl;
        this.paymentMethod = paymentMethod;
        this.cancelUrl = cancelUrl;
        this.ipAddress = ipAddress;
        this.userAgent = userAgent;
        this.expiration = expiration;
        this.captureAddress = captureAddress;
        this.noBuyerFill = noBuyerFill;
    }

    public RedirectRequest(String content) {
        this(new JSONObject(content));
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public String language() {
        return this.locale.substring(0, 2).toUpperCase();
    }

    public String getLocale() {
        return this.locale;
    }

    public Person getPayer() {
        return this.payer;
    }

    public Person getBuyer() {
        return this.buyer;
    }

    public Payment getPayment() {
        return this.payment;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public String getCancelUrl() {
        return this.cancelUrl;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getReference() {
        if (this.payment != null) {
            return this.payment.getReference();
        }
        return this.subscription.getReference();
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public boolean getCaptureAddress() {
        return this.captureAddress;
    }

    public boolean isSkipResult() {
        return this.skipResult;
    }

    public boolean noBuyerFill() {
        return this.noBuyerFill;
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        object.put("locale", (Object)this.locale);
        object.put("payer", this.payer == null ? null : this.payer.toJsonObject());
        object.put("buyer", this.buyer == null ? null : this.buyer.toJsonObject());
        object.put("payment", this.payment == null ? null : this.payment.toJsonObject());
        object.put("subscription", this.subscription == null ? null : this.subscription.toJsonObject());
        object.put("fields", (Object)this.fieldsToArrayObject());
        object.put("returnUrl", (Object)this.returnUrl);
        object.put("paymentMethod", (Object)this.paymentMethod);
        object.put("cancelUrl", (Object)this.cancelUrl);
        object.put("ipAddress", (Object)this.ipAddress);
        object.put("userAgent", (Object)this.userAgent);
        object.put("expiration", (Object)this.expiration);
        object.put("captureAddress", this.captureAddress);
        object.put("skipResult", this.skipResult);
        object.put("noBuyerFill", this.noBuyerFill);
        return Entity.filterJSONObject(object);
    }
}

