/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.Amount;
import com.placetopay.java_placetopay.Entities.EntityWithNameValuePair;
import com.placetopay.java_placetopay.Entities.Instrument;
import com.placetopay.java_placetopay.Entities.Item;
import com.placetopay.java_placetopay.Entities.Person;
import com.placetopay.java_placetopay.Entities.Recurring;
import com.placetopay.java_placetopay.Utils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Payment
extends EntityWithNameValuePair {
    protected String reference;
    protected String description;
    protected Amount amount;
    protected boolean allowPartial = false;
    protected Person shipping;
    protected List<Item> items;
    protected Recurring recurring;
    protected Instrument instrument;

    public Payment(JSONObject object) {
        super(object);
        this.reference = object.has("reference") ? object.getString("reference") : null;
        this.allowPartial = object.has("allowPartial") ? object.getBoolean("allowPartial") : false;
        this.description = object.has("description") ? object.getString("description") : null;
        this.amount = object.has("amount") ? new Amount(object.getJSONObject("amount")) : null;
        this.shipping = object.has("shipping") ? new Person(object.getJSONObject("shipping")) : null;
        this.items = object.has("items") ? Payment.convertToItems(object.get("items")) : null;
        this.recurring = object.has("recurring") ? new Recurring(object.getJSONObject("recurring")) : null;
        this.instrument = object.has("instrument") ? new Instrument(object.getJSONObject("instrument")) : null;
    }

    public Payment(String reference, String description, Amount amount, boolean allowPartial, Person shipping, List<Item> items, Recurring recurring, Instrument instrument) {
        this.reference = reference;
        this.description = description;
        this.amount = amount;
        this.allowPartial = allowPartial;
        this.shipping = shipping;
        this.items = items;
        this.recurring = recurring;
        this.instrument = instrument;
    }

    public String getReference() {
        return this.reference;
    }

    public String getDescription() {
        return this.description;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public boolean isAllowPartial() {
        return this.allowPartial;
    }

    public Person getShipping() {
        return this.shipping;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Recurring getRecurring() {
        return this.recurring;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public JSONArray itemToJsonArray() {
        JSONArray jsonArray = new JSONArray();
        for (Item item : this.items) {
            jsonArray.put((Object)item.toJsonObject());
        }
        return jsonArray;
    }

    private static List<Item> convertToItems(Object json) {
        return Utils.convertToList(json, "items", Item.class);
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        object.put("reference", (Object)this.reference);
        object.put("description", (Object)this.description);
        object.put("amount", this.amount == null ? null : this.amount.toJsonObject());
        object.put("allowPartial", this.allowPartial);
        object.put("shipping", this.shipping == null ? null : this.shipping.toJsonObject());
        object.put("items", (Object)(this.items == null ? null : this.itemToJsonArray()));
        object.put("recurring", this.recurring == null ? null : this.recurring.toJsonObject());
        object.put("instrument", this.instrument == null ? null : this.instrument.toJsonObject());
        object.put("fields", (Object)this.fieldsToArrayObject());
        return Entity.filterJSONObject(object);
    }
}

