/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities;

import com.placetopay.java_placetopay.Contracts.Entity;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Status
extends Entity {
    public static final String ST_OK = "OK";
    public static final String ST_FAILED = "FAILED";
    public static final String ST_APPROVED = "APPROVED";
    public static final String ST_APPROVED_PARTIAL = "APPROVED_PARTIAL";
    public static final String ST_REJECTED = "REJECTED";
    public static final String ST_PENDING = "PENDING";
    public static final String ST_PENDING_VALIDATION = "PENDING_VALIDATION";
    public static final String ST_REFUNDED = "REFUNDED";
    public static final String ST_ERROR = "ERROR";
    public static final String ST_UNKNOWN = "UNKNOWN";
    protected String status;
    protected String reason;
    protected String message;
    protected String date;
    protected static String[] STATUSES = new String[]{"OK", "FAILED", "APPROVED", "APPROVED_PARTIAL", "REJECTED", "PENDING", "PENDING_VALIDATION", "REFUNDED", "ERROR", "UNKNOWN"};

    public Status(String content) throws JSONException {
        this(new JSONObject(content));
    }

    public Status(JSONObject object) {
        this.status = object.getString("status");
        this.reason = object.get("reason").toString();
        this.message = object.getString("message");
        this.date = object.getString("date");
    }

    public Status(String status, String reason, String message, String date) {
        this.status = status;
        this.reason = reason;
        this.message = message;
        this.date = date;
    }

    public Status(String status, String reason, String message) {
        this.status = status;
        this.reason = reason;
        this.message = message;
        this.date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
    }

    public String getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDate() {
        return this.date;
    }

    public boolean isFailed() {
        return this.status.equals(ST_FAILED);
    }

    public boolean isSuccessful() {
        return this.status.equals(ST_OK);
    }

    public boolean isApproved() {
        return this.status.equals(ST_APPROVED);
    }

    public boolean isRejected() {
        return this.status.equals(ST_REJECTED);
    }

    public boolean isError() {
        return this.status.equals(ST_ERROR);
    }

    public static boolean validStatus(String status) {
        if (status != null) {
            return Arrays.asList(STATUSES).contains(status);
        }
        return false;
    }

    public static String[] validStatus() {
        return STATUSES;
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        object.put("status", (Object)this.status);
        object.put("reason", (Object)this.reason);
        object.put("message", (Object)this.message);
        object.put("date", (Object)this.date);
        return object;
    }
}

