/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.Account;
import com.placetopay.java_placetopay.Entities.NameValuePair;
import com.placetopay.java_placetopay.Entities.Status;
import com.placetopay.java_placetopay.Entities.Token;
import com.placetopay.java_placetopay.Utils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SubscriptionInformation
extends Entity {
    public String type;
    public Status status;
    public List<NameValuePair> instrument;

    public SubscriptionInformation(JSONObject object) {
        this(object.has("type") ? object.getString("type") : null, object.has("status") ? new Status(object.getJSONObject("status")) : null, object.has("instrument") ? SubscriptionInformation.setInstrument(object.get("instrument")) : null);
    }

    public SubscriptionInformation(String type, Status status, List<NameValuePair> instrument) {
        this.type = type;
        this.status = status;
        this.instrument = instrument;
    }

    public String getType() {
        return this.type;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<NameValuePair> getInstrument() {
        return this.instrument;
    }

    public JSONArray instrumentToArray() {
        JSONArray jsona = new JSONArray();
        for (NameValuePair pair : this.instrument) {
            jsona.put((Object)pair.toJsonObject());
        }
        return jsona;
    }

    public Entity parseInstrument() {
        List<NameValuePair> instrumentNVP = this.instrument;
        if (instrumentNVP == null) {
            return null;
        }
        JSONObject object = new JSONObject();
        object.put("status", (Object)this.getStatus().toJsonObject());
        for (NameValuePair pair : instrumentNVP) {
            object.put(pair.getKeyword(), (Object)pair.getValue());
        }
        if (this.type.equals("token")) {
            return new Token(object);
        }
        if (this.type.equals("acccount")) {
            return new Account(object);
        }
        return null;
    }

    private static List<NameValuePair> setInstrument(Object json) {
        return Utils.convertToList(json, "item", NameValuePair.class);
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        object.put("type", (Object)this.type);
        object.put("status", this.status == null ? null : this.status.toJsonObject());
        object.put("instrument", (Object)(this.instrument == null ? null : this.instrumentToArray()));
        return Entity.filterJSONObject(object);
    }
}

