/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.Status;
import com.placetopay.java_placetopay.Exceptions.PlaceToPayException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.json.JSONObject;

public class Token
extends Entity {
    protected Status status;
    protected String token;
    protected String subtoken;
    protected String franchise;
    protected String franchiseName;
    protected String issuerName;
    protected String lastDigits;
    protected String validUntil;
    protected String cvv;
    protected Integer installments;

    public Token(JSONObject object) {
        this(object.has("token") ? object.getString("token") : null, object.has("subtoken") ? object.getString("subtoken") : null, object.has("franchise") ? object.getString("franchise") : null, object.has("franchiseName") ? object.getString("franchiseName") : null, object.has("issuerName") ? object.getString("issuerName") : null, object.has("lastDigits") ? object.getString("lastDigits") : null, object.has("validUntil") ? object.getString("validUntil") : null, object.has("cvv") ? object.getString("cvv") : null, object.has("installments") ? Integer.valueOf(Integer.parseInt(object.get("installments").toString())) : null);
        if (object.has("status")) {
            this.status = new Status(object.getJSONObject("status"));
        }
    }

    public Token(String token, String subtoken, String franchise, String franchiseName, String issuerName, String lastDigits, String validUntil, String cvv, Integer installments, Status status) {
        this(token, subtoken, franchise, franchiseName, issuerName, lastDigits, validUntil, cvv, installments);
        this.status = status;
    }

    public Token(String token, String subtoken, String franchise, String franchiseName, String issuerName, String lastDigits, String validUntil, String cvv, Integer installments) {
        this.token = token;
        this.subtoken = subtoken;
        this.franchise = franchise;
        this.franchiseName = franchiseName;
        this.issuerName = issuerName;
        this.lastDigits = lastDigits;
        this.validUntil = validUntil;
        this.cvv = cvv;
        this.installments = installments;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getToken() {
        return this.token;
    }

    public String getFranchise() {
        return this.franchise;
    }

    public String getSubtoken() {
        return this.subtoken;
    }

    public String getFranchiseName() {
        return this.franchiseName;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getLastDigits() {
        return this.lastDigits;
    }

    public String getValidUntil() {
        return this.validUntil;
    }

    public String getExpiration() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        SimpleDateFormat formatTo = new SimpleDateFormat("M/yy", Locale.US);
        try {
            return formatTo.format(dateFormat.parse(this.validUntil));
        }
        catch (ParseException ex) {
            throw new PlaceToPayException("Invalid expiration in token: " + ex.getMessage());
        }
    }

    public String getCvv() {
        return this.cvv;
    }

    public Integer getInstallments() {
        return this.installments;
    }

    public boolean isSuccessful() {
        return this.status.getStatus().equals("OK");
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        object.put("status", this.status == null ? null : this.status.toJsonObject());
        object.put("token", (Object)this.token);
        object.put("subtoken", (Object)this.subtoken);
        object.put("franchise", (Object)this.franchise);
        object.put("franchiseName", (Object)this.franchiseName);
        object.put("issuerName", (Object)this.issuerName);
        object.put("lastDigits", (Object)this.lastDigits);
        object.put("validUntil", (Object)this.validUntil);
        object.put("cvv", (Object)this.cvv);
        object.put("installments", (Object)this.installments);
        return Entity.filterJSONObject(object);
    }
}

