/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Entities;

import com.placetopay.java_placetopay.Contracts.Entity;
import com.placetopay.java_placetopay.Entities.AmountBase;
import com.placetopay.java_placetopay.Entities.AmountConversion;
import com.placetopay.java_placetopay.Entities.NameValuePair;
import com.placetopay.java_placetopay.Entities.Status;
import com.placetopay.java_placetopay.Utils;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Transaction
extends Entity {
    protected Status status;
    protected String reference;
    protected Integer internalReference;
    protected String paymentMethod;
    protected String paymentMethodName;
    protected String issuerName;
    protected AmountConversion amount;
    protected String authorization;
    protected Long receipt;
    protected String franchise;
    protected boolean refunded = false;
    protected List<NameValuePair> processorFields;

    public Transaction(JSONObject object) {
        this.status = object.has("status") ? new Status(object.getJSONObject("status")) : null;
        this.reference = object.has("reference") ? object.getString("reference") : null;
        this.internalReference = object.has("internalReference") ? Integer.valueOf(object.getInt("internalReference")) : null;
        this.paymentMethod = object.has("paymentMethod") ? object.getString("paymentMethod") : null;
        this.paymentMethodName = object.has("paymentMethodName") ? object.getString("paymentMethodName") : null;
        this.issuerName = object.has("issuerName") ? object.getString("issuerName") : null;
        this.amount = object.has("amount") ? new AmountConversion(object.getJSONObject("amount")) : null;
        this.authorization = object.has("authorization") ? object.getString("authorization") : null;
        this.receipt = object.has("receipt") ? Long.valueOf(object.getLong("receipt")) : null;
        this.franchise = object.has("franchise") ? object.getString("franchise") : null;
        this.refunded = object.has("refunded") ? object.getBoolean("refunded") : false;
        this.processorFields = object.has("processorFields") ? Transaction.setProcessorFields(object.get("processorFields")) : null;
    }

    public Transaction(Status status, String reference, Integer internalReference, String paymentMethod, String paymentMethodName, String issuerName, AmountConversion amount, String authorization, Long receipt, String franchise, boolean refunded, List<NameValuePair> processorFields) {
        this.status = status;
        this.reference = reference;
        this.internalReference = internalReference;
        this.paymentMethod = paymentMethod;
        this.paymentMethodName = paymentMethodName;
        this.issuerName = issuerName;
        this.amount = amount;
        this.authorization = authorization;
        this.receipt = receipt;
        this.franchise = franchise;
        this.refunded = refunded;
        this.processorFields = processorFields;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public Integer getInternalReference() {
        return this.internalReference;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getPaymentMethodName() {
        return this.paymentMethodName;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public AmountConversion getAmount() {
        return this.amount;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public Long getReceipt() {
        return this.receipt;
    }

    public String getFranchise() {
        return this.franchise;
    }

    public boolean isRefunded() {
        return this.refunded;
    }

    public List<NameValuePair> getProcessorFields() {
        return this.processorFields;
    }

    public void setAmountBase(JSONObject base) {
        AmountBase base1 = new AmountBase(base);
        this.amount = new AmountConversion().setAmountBase(base1);
    }

    public boolean isSuccessful() {
        return this.status != null && !this.status.getStatus().equals("ERROR");
    }

    public boolean isApproved() {
        return this.status != null && this.status.getStatus().equals("APPROVED");
    }

    public JSONArray processorFieldsToArray() {
        JSONArray jsona = new JSONArray();
        for (NameValuePair pair : this.processorFields) {
            jsona.put((Object)pair.toJsonObject());
        }
        return jsona;
    }

    private static List<NameValuePair> setProcessorFields(Object json) {
        return Utils.convertToList(json, "item", NameValuePair.class);
    }

    public JSONObject additionalData() {
        if (this.processorFields != null) {
            JSONObject object = new JSONObject();
            for (NameValuePair pair : this.processorFields) {
                object.put(pair.keyword, (Object)pair.value);
            }
            return object;
        }
        return new JSONObject();
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject object = new JSONObject();
        object.put("status", this.status == null ? null : this.status.toJsonObject());
        object.put("internalReference", (Object)this.internalReference);
        object.put("paymentMethod", (Object)this.paymentMethod);
        object.put("paymentMethodName", (Object)this.paymentMethodName);
        object.put("issuerName", (Object)this.issuerName);
        object.put("amount", this.amount == null ? null : this.amount.toJsonObject());
        object.put("authorization", (Object)this.authorization);
        object.put("reference", (Object)this.reference);
        object.put("receipt", (Object)this.receipt);
        object.put("franchise", (Object)this.franchise);
        object.put("refunded", this.refunded);
        object.put("processorFields", (Object)(this.processorFields == null ? null : this.processorFieldsToArray()));
        return Entity.filterJSONObject(object);
    }
}

