/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class Util {
    public static void notNull(Object o, String name) {
        if (o == null) {
            throw new IllegalArgumentException(name + " == null");
        }
    }

    public static void notEmpty(Collection c, String name) {
        Util.notNull(c, name);
        if (c.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty");
        }
    }

    public static void notEmpty(Object[] arr, String name) {
        Util.notNull(arr, name);
        if (arr.length == 0) {
            throw new IllegalArgumentException(name + "must not be empty");
        }
    }

    public static void notEmpty(Map m, String name) {
        Util.notNull(m, name);
        if (m.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty");
        }
    }

    public static void isBetween(Integer i, int min, int max, String name) {
        Util.notNull(i, name);
        if (i < min || i > max) {
            throw new IllegalArgumentException(name + "(" + i + ") out of range: " + min + " <= " + name + " <= " + max);
        }
    }

    public static void isPositive(Integer i, String name) {
        Util.notNull(i, name);
        if (i < 0) {
            throw new IllegalArgumentException(name + "must be a positive number.");
        }
    }

    public static Map<String, String> arrayToMap(String[] args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Must pass in an even number of args, one key per value.");
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            ret.put(args[i], args[i + 1]);
        }
        return ret;
    }
}

