/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.internal.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.internal.gson.Optional;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class OptionalTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!Optional.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        final TypeAdapter delegateAdapter = gson.getAdapter(TypeToken.get((Type)((ParameterizedType)type.getType()).getActualTypeArguments()[0]));
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (((Optional)value).isPresent()) {
                    delegateAdapter.write(out, ((Optional)value).get());
                } else {
                    out.nullValue();
                }
            }

            public T read(JsonReader in) throws IOException {
                Object readObject = delegateAdapter.read(in);
                if (readObject == null) {
                    return Optional.empty();
                }
                return Optional.of(readObject);
            }
        };
    }
}

