/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.request;

import com.google.gson.annotations.JsonAdapter;
import com.plaid.client.internal.Util;
import com.plaid.client.internal.gson.DateOnlyTypeAdapterFactory;
import com.plaid.client.internal.gson.Optional;
import com.plaid.client.internal.gson.RequiredField;
import com.plaid.client.request.common.BaseClientRequest;
import com.plaid.client.request.common.Product;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ItemCreateRequest
extends BaseClientRequest {
    private RequiredField<Map<String, String>> credentials = RequiredField.empty();
    private String institutionId;
    private List<Product> initialProducts;
    private Optional<Options> options = Optional.empty();

    public ItemCreateRequest(String institutionId, List<Product> initialProducts) {
        Util.notNull(institutionId, "institutionId");
        Util.notEmpty(initialProducts, "initialProducts");
        this.initialProducts = new ArrayList<Product>(initialProducts);
        this.institutionId = institutionId;
    }

    public ItemCreateRequest withCredentials(Map<String, String> credentials) {
        Util.notNull(credentials, "credentials");
        this.credentials = RequiredField.of(new HashMap<String, String>(credentials));
        return this;
    }

    public ItemCreateRequest withCredentials(String name, String value) {
        if (!this.credentials.isPresent()) {
            this.credentials = RequiredField.of(new HashMap());
        }
        this.credentials.get().put(name, value);
        return this;
    }

    public ItemCreateRequest withOptionWebhook(String webhook) {
        Util.notNull(webhook, "webhook");
        this.options = this.options.orElse(new Options());
        this.options.get().webhook = webhook;
        return this;
    }

    public ItemCreateRequest withOptionCredentialsToken(String credentialsToken) {
        Util.notNull(credentialsToken, "credentialsToken");
        this.options = this.options.orElse(new Options());
        this.options.get().credentialsToken = credentialsToken;
        return this;
    }

    public ItemCreateRequest withOptionStartDate(Date startDate) {
        Util.notNull(startDate, "startDate");
        this.options = this.options.orElse(new Options());
        this.options.get().transactions = this.options.get().transactions.orElse(new Options.TransactionOptions());
        ((Options.TransactionOptions)this.options.get().transactions.get()).startDate = new Date(startDate.getTime());
        return this;
    }

    public ItemCreateRequest withOptionEndDate(Date endDate) {
        Util.notNull(endDate, "endDate");
        this.options = this.options.orElse(new Options());
        this.options.get().transactions = this.options.get().transactions.orElse(new Options.TransactionOptions());
        ((Options.TransactionOptions)this.options.get().transactions.get()).endDate = new Date(endDate.getTime());
        return this;
    }

    public ItemCreateRequest withOptionAwaitResults(boolean awaitResults) {
        this.options = this.options.orElse(new Options());
        this.options.get().transactions = this.options.get().transactions.orElse(new Options.TransactionOptions());
        ((Options.TransactionOptions)this.options.get().transactions.get()).awaitResults = awaitResults;
        return this;
    }

    private static class Options {
        private Optional<TransactionOptions> transactions = Optional.empty();
        private String webhook;
        private String credentialsToken;

        private Options() {
        }

        private static class TransactionOptions {
            @JsonAdapter(value=DateOnlyTypeAdapterFactory.class)
            private Date startDate;
            @JsonAdapter(value=DateOnlyTypeAdapterFactory.class)
            private Date endDate;
            private Boolean awaitResults;

            private TransactionOptions() {
            }
        }
    }
}

