/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.request;

import com.plaid.client.internal.Util;
import com.plaid.client.internal.gson.RequiredField;
import com.plaid.client.request.common.BaseAccessTokenRequest;
import java.util.HashMap;
import java.util.Map;

public final class ItemCredentialsUpdateRequest
extends BaseAccessTokenRequest {
    private RequiredField<Map<String, String>> credentials = RequiredField.empty();
    private Options options;

    public ItemCredentialsUpdateRequest(String accessToken) {
        super(accessToken);
    }

    public ItemCredentialsUpdateRequest withCredentials(Map<String, String> credentials) {
        Util.notEmpty(credentials, "credentials");
        this.credentials = RequiredField.of(new HashMap<String, String>(credentials));
        return this;
    }

    public ItemCredentialsUpdateRequest withCredentials(String ... credentials) {
        this.credentials = RequiredField.of(Util.arrayToMap(credentials));
        return this;
    }

    public ItemCredentialsUpdateRequest withCredentialsToken(String credentialsToken) {
        Util.notNull(credentialsToken, "credentialsToken");
        this.options = new Options(credentialsToken);
        return this;
    }

    private static class Options {
        private String credentialsToken;

        private Options(String credentialsToken) {
            this.credentialsToken = credentialsToken;
        }
    }
}

