/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.request;

import com.plaid.client.internal.Util;
import com.plaid.client.internal.gson.RequiredField;
import com.plaid.client.request.common.BaseAccessTokenRequest;
import com.plaid.client.request.common.MfaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ItemMfaRequest
extends BaseAccessTokenRequest {
    private final MfaType mfaType;
    private RequiredField<List<String>> responses = RequiredField.empty();
    private Options options;

    public ItemMfaRequest(String accessToken, MfaType mfaType) {
        super(accessToken);
        Util.notNull((Object)mfaType, "mfaType");
        this.mfaType = mfaType;
    }

    public ItemMfaRequest withResponsesToken(String responsesToken) {
        this.options = new Options(responsesToken);
        return this;
    }

    public ItemMfaRequest withResponses(String ... responses) {
        this.withResponses(Arrays.asList(responses));
        return this;
    }

    public ItemMfaRequest withResponses(List<String> responses) {
        Util.notEmpty(responses, "responses");
        this.responses = RequiredField.of(new ArrayList<String>(responses));
        return this;
    }

    private static class Options {
        private final String responsesToken;

        private Options(String responsesToken) {
            this.responsesToken = responsesToken;
        }
    }
}

