/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.request;

import com.google.gson.annotations.JsonAdapter;
import com.plaid.client.internal.Util;
import com.plaid.client.internal.gson.DateOnlyTypeAdapterFactory;
import com.plaid.client.internal.gson.Optional;
import com.plaid.client.request.common.BaseAccessTokenRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class TransactionsGetRequest
extends BaseAccessTokenRequest {
    @JsonAdapter(value=DateOnlyTypeAdapterFactory.class)
    private Date startDate;
    @JsonAdapter(value=DateOnlyTypeAdapterFactory.class)
    private Date endDate;
    private Optional<Options> options = Optional.empty();

    public TransactionsGetRequest(String accessToken, Date startDate, Date endDate) {
        super(accessToken);
        Util.notNull(startDate, "startDate");
        Util.notNull(endDate, "endDate");
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public TransactionsGetRequest withAccountIds(List<String> accountIds) {
        this.options = this.options.orElse(new Options());
        this.options.get().accountIds = new ArrayList<String>(accountIds);
        return this;
    }

    public TransactionsGetRequest withCount(int count) {
        this.options = this.options.orElse(new Options());
        this.options.get().count = count;
        this.validateOptions(this.options.get());
        return this;
    }

    public TransactionsGetRequest withOffset(int offset) {
        Util.isPositive(offset, "offset");
        this.options = this.options.orElse(new Options());
        this.options.get().offset = offset;
        this.validateOptions(this.options.get());
        return this;
    }

    private void validateOptions(Options options) {
        if (options.count != null) {
            Util.isBetween(options.count, 0, 500, "count");
        }
        if (options.offset != null) {
            Util.isPositive(options.offset, "offset");
        }
    }

    public TransactionsGetRequest withOptions(Options options) {
        Util.notNull(options, "options");
        this.options = Optional.of(options);
        this.validateOptions(this.options.get());
        return this;
    }

    public static class Options {
        private List<String> accountIds;
        private Integer count;
        private Integer offset;
    }
}

