/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client;

import com.plaid.client.GsonCustomConverterFactory;
import com.plaid.client.JSON;
import com.plaid.client.auth.ApiKeyAuth;
import com.plaid.client.auth.HttpBasicAuth;
import com.plaid.client.auth.HttpBearerAuth;
import java.io.IOException;
import java.text.DateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ApiClient {
    private Map<String, Interceptor> apiAuthorizations = new LinkedHashMap<String, Interceptor>();
    private OkHttpClient.Builder okBuilder;
    private Retrofit.Builder adapterBuilder;
    private JSON json;
    private OkHttpClient okHttpClient;
    public static final String Production = "https://production.plaid.com";
    public static final String Sandbox = "https://sandbox.plaid.com";

    public ApiClient() {
        this.createDefaultAdapter();
        this.okBuilder = new OkHttpClient.Builder().readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                Request requestWithUserAgent = originalRequest.newBuilder().header("User-Agent", "Plaid Java v25.0.0").header("Plaid-Version", "2020-09-14").build();
                return chain.proceed(requestWithUserAgent);
            }
        });
    }

    public ApiClient(OkHttpClient client) {
        this.createDefaultAdapter();
        this.okHttpClient = client;
    }

    public ApiClient(String[] authNames) {
        this();
        for (String authName : authNames) {
            ApiKeyAuth auth;
            if ("clientId".equals(authName)) {
                auth = new ApiKeyAuth("header", "PLAID-CLIENT-ID");
            } else if ("plaidVersion".equals(authName)) {
                auth = new ApiKeyAuth("header", "Plaid-Version");
            } else if ("secret".equals(authName)) {
                auth = new ApiKeyAuth("header", "PLAID-SECRET");
            } else {
                throw new RuntimeException("auth name \"" + authName + "\" not found in available auth names");
            }
            this.addAuthorization(authName, auth);
        }
    }

    public ApiClient(Map<String, String> apiKeys) {
        this();
        for (String authName : apiKeys.keySet()) {
            ApiKeyAuth auth;
            ApiKeyAuth apiKeyAuth;
            if ("clientId".equals(authName)) {
                apiKeyAuth = new ApiKeyAuth("header", "PLAID-CLIENT-ID");
                apiKeyAuth.setApiKey(apiKeys.get(authName));
                auth = apiKeyAuth;
            } else if ("plaidVersion".equals(authName)) {
                apiKeyAuth = new ApiKeyAuth("header", "Plaid-Version");
                apiKeyAuth.setApiKey(apiKeys.get(authName));
                auth = apiKeyAuth;
            } else if ("secret".equals(authName)) {
                apiKeyAuth = new ApiKeyAuth("header", "PLAID-SECRET");
                apiKeyAuth.setApiKey(apiKeys.get(authName));
                auth = apiKeyAuth;
            } else {
                throw new RuntimeException("auth name \"" + authName + "\" not found in available auth names");
            }
            this.addAuthorization(authName, auth);
        }
    }

    public ApiClient(String authName) {
        this(new String[]{authName});
    }

    public ApiClient(String authName, String apiKey) {
        this(authName);
        this.setApiKey(apiKey);
    }

    public ApiClient(String authName, String username, String password) {
        this(authName);
        this.setCredentials(username, password);
    }

    public void createDefaultAdapter() {
        this.json = new JSON();
        String baseUrl = Production;
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.adapterBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonCustomConverterFactory.create(this.json.getGson()));
    }

    public void setPlaidAdapter(String baseUrl) {
        this.json = new JSON();
        List<String> PLAID_ENVS = Arrays.asList(Sandbox, Production);
        if (!PLAID_ENVS.contains(baseUrl)) {
            System.out.println("baseUrl not found in PLAID_ENVS, must be one of the following: https://sandbox.plaid.com, https://production.plaid.com");
        }
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.adapterBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonCustomConverterFactory.create(this.json.getGson()));
    }

    public void setTimeout(int overrideTimeout) {
        this.okBuilder.readTimeout((long)overrideTimeout, TimeUnit.SECONDS).connectTimeout((long)overrideTimeout, TimeUnit.SECONDS);
    }

    public <S> S createService(Class<S> serviceClass) {
        if (this.okHttpClient != null) {
            return (S)this.adapterBuilder.client(this.okHttpClient).build().create(serviceClass);
        }
        return (S)this.adapterBuilder.client(this.okBuilder.build()).build().create(serviceClass);
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.json.setDateFormat(dateFormat);
        return this;
    }

    public ApiClient setSqlDateFormat(DateFormat dateFormat) {
        this.json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ApiClient setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        this.json.setOffsetDateTimeFormat(dateFormat);
        return this;
    }

    public ApiClient setLocalDateFormat(DateTimeFormatter dateFormat) {
        this.json.setLocalDateFormat(dateFormat);
        return this;
    }

    public ApiClient setApiKey(String apiKey) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof ApiKeyAuth)) continue;
            ApiKeyAuth keyAuth = (ApiKeyAuth)apiAuthorization;
            keyAuth.setApiKey(apiKey);
            return this;
        }
        return this;
    }

    public ApiClient setBearerToken(String bearerToken) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof HttpBearerAuth)) continue;
            ((HttpBearerAuth)apiAuthorization).setBearerToken(bearerToken);
            return this;
        }
        return this;
    }

    public ApiClient setCredentials(String username, String password) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof HttpBasicAuth)) continue;
            HttpBasicAuth basicAuth = (HttpBasicAuth)apiAuthorization;
            basicAuth.setCredentials(username, password);
            return this;
        }
        return this;
    }

    public ApiClient addAuthorization(String authName, Interceptor authorization) {
        if (this.apiAuthorizations.containsKey(authName)) {
            throw new RuntimeException("auth name \"" + authName + "\" already in api authorizations");
        }
        this.apiAuthorizations.put(authName, authorization);
        if (this.okBuilder == null) {
            throw new RuntimeException("The ApiClient was created with a built OkHttpClient so it's not possible to add an authorization interceptor to it");
        }
        this.okBuilder.addInterceptor(authorization);
        return this;
    }

    public Map<String, Interceptor> getApiAuthorizations() {
        return this.apiAuthorizations;
    }

    public ApiClient setApiAuthorizations(Map<String, Interceptor> apiAuthorizations) {
        this.apiAuthorizations = apiAuthorizations;
        return this;
    }

    public Retrofit.Builder getAdapterBuilder() {
        return this.adapterBuilder;
    }

    public ApiClient setAdapterBuilder(Retrofit.Builder adapterBuilder) {
        this.adapterBuilder = adapterBuilder;
        return this;
    }

    public OkHttpClient.Builder getOkBuilder() {
        return this.okBuilder;
    }

    public void addAuthsToOkBuilder(OkHttpClient.Builder okBuilder) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            okBuilder.addInterceptor(apiAuthorization);
        }
    }

    public void configureFromOkclient(OkHttpClient okClient) {
        this.okBuilder = okClient.newBuilder();
        this.addAuthsToOkBuilder(this.okBuilder);
    }
}

