/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.auth;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HttpBearerAuth
implements Interceptor {
    private final String scheme;
    private String bearerToken;

    public HttpBearerAuth(String scheme) {
        this.scheme = scheme;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.header("Authorization") == null && this.bearerToken != null) {
            request = request.newBuilder().addHeader("Authorization", (this.scheme != null ? HttpBearerAuth.upperCaseBearer(this.scheme) + " " : "") + this.bearerToken).build();
        }
        return chain.proceed(request);
    }

    private static String upperCaseBearer(String scheme) {
        return "bearer".equalsIgnoreCase(scheme) ? "Bearer" : scheme;
    }
}

