/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information about the APR on the account.")
public class APR {
    public static final String SERIALIZED_NAME_APR_PERCENTAGE = "apr_percentage";
    @SerializedName(value="apr_percentage")
    private Double aprPercentage;
    public static final String SERIALIZED_NAME_APR_TYPE = "apr_type";
    @SerializedName(value="apr_type")
    private AprTypeEnum aprType;
    public static final String SERIALIZED_NAME_BALANCE_SUBJECT_TO_APR = "balance_subject_to_apr";
    @SerializedName(value="balance_subject_to_apr")
    private Double balanceSubjectToApr;
    public static final String SERIALIZED_NAME_INTEREST_CHARGE_AMOUNT = "interest_charge_amount";
    @SerializedName(value="interest_charge_amount")
    private Double interestChargeAmount;

    public APR aprPercentage(Double aprPercentage) {
        this.aprPercentage = aprPercentage;
        return this;
    }

    @ApiModelProperty(required=true, value="Annual Percentage Rate applied. ")
    public Double getAprPercentage() {
        return this.aprPercentage;
    }

    public void setAprPercentage(Double aprPercentage) {
        this.aprPercentage = aprPercentage;
    }

    public APR aprType(AprTypeEnum aprType) {
        this.aprType = aprType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of balance to which the APR applies.")
    public AprTypeEnum getAprType() {
        return this.aprType;
    }

    public void setAprType(AprTypeEnum aprType) {
        this.aprType = aprType;
    }

    public APR balanceSubjectToApr(Double balanceSubjectToApr) {
        this.balanceSubjectToApr = balanceSubjectToApr;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Amount of money that is subjected to the APR if a balance was carried beyond payment due date. How it is calculated can vary by card issuer. It is often calculated as an average daily balance.")
    public Double getBalanceSubjectToApr() {
        return this.balanceSubjectToApr;
    }

    public void setBalanceSubjectToApr(Double balanceSubjectToApr) {
        this.balanceSubjectToApr = balanceSubjectToApr;
    }

    public APR interestChargeAmount(Double interestChargeAmount) {
        this.interestChargeAmount = interestChargeAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Amount of money charged due to interest from last statement.")
    public Double getInterestChargeAmount() {
        return this.interestChargeAmount;
    }

    public void setInterestChargeAmount(Double interestChargeAmount) {
        this.interestChargeAmount = interestChargeAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APR APR2 = (APR)o;
        return Objects.equals(this.aprPercentage, APR2.aprPercentage) && Objects.equals((Object)this.aprType, (Object)APR2.aprType) && Objects.equals(this.balanceSubjectToApr, APR2.balanceSubjectToApr) && Objects.equals(this.interestChargeAmount, APR2.interestChargeAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aprPercentage, this.aprType, this.balanceSubjectToApr, this.interestChargeAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APR {\n");
        sb.append("    aprPercentage: ").append(this.toIndentedString(this.aprPercentage)).append("\n");
        sb.append("    aprType: ").append(this.toIndentedString((Object)this.aprType)).append("\n");
        sb.append("    balanceSubjectToApr: ").append(this.toIndentedString(this.balanceSubjectToApr)).append("\n");
        sb.append("    interestChargeAmount: ").append(this.toIndentedString(this.interestChargeAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AprTypeEnum {
        BALANCE_TRANSFER_APR("balance_transfer_apr"),
        CASH_APR("cash_apr"),
        PURCHASE_APR("purchase_apr"),
        SPECIAL("special");

        private String value;

        private AprTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AprTypeEnum fromValue(String value) {
            for (AprTypeEnum b : AprTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AprTypeEnum> {
            public void write(JsonWriter jsonWriter, AprTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AprTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AprTypeEnum.fromValue(value);
            }
        }
    }
}

