/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountProductAccessNullable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Allow or disallow product access by account. Unlisted (e.g. missing) accounts will be considered `new_accounts`.")
public class AccountAccess {
    public static final String SERIALIZED_NAME_UNIQUE_ID = "unique_id";
    @SerializedName(value="unique_id")
    private String uniqueId;
    public static final String SERIALIZED_NAME_AUTHORIZED = "authorized";
    @SerializedName(value="authorized")
    private Boolean authorized = true;
    public static final String SERIALIZED_NAME_ACCOUNT_PRODUCT_ACCESS = "account_product_access";
    @SerializedName(value="account_product_access")
    private AccountProductAccessNullable accountProductAccess;

    public AccountAccess uniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique account identifier for this account. This value must match that returned by the data access API for this account.")
    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public AccountAccess authorized(Boolean authorized) {
        this.authorized = authorized;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow the application to see this account (and associated details, including balance) in the list of accounts  If unset, defaults to `true`.")
    public Boolean getAuthorized() {
        return this.authorized;
    }

    public void setAuthorized(Boolean authorized) {
        this.authorized = authorized;
    }

    public AccountAccess accountProductAccess(AccountProductAccessNullable accountProductAccess) {
        this.accountProductAccess = accountProductAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccountProductAccessNullable getAccountProductAccess() {
        return this.accountProductAccess;
    }

    public void setAccountProductAccess(AccountProductAccessNullable accountProductAccess) {
        this.accountProductAccess = accountProductAccess;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountAccess accountAccess = (AccountAccess)o;
        return Objects.equals(this.uniqueId, accountAccess.uniqueId) && Objects.equals(this.authorized, accountAccess.authorized) && Objects.equals(this.accountProductAccess, accountAccess.accountProductAccess);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.authorized, this.accountProductAccess);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountAccess {\n");
        sb.append("    uniqueId: ").append(this.toIndentedString(this.uniqueId)).append("\n");
        sb.append("    authorized: ").append(this.toIndentedString(this.authorized)).append("\n");
        sb.append("    accountProductAccess: ").append(this.toIndentedString(this.accountProductAccess)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

