/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.AccountHolderCategory;
import com.plaid.client.model.AccountSubtype;
import com.plaid.client.model.AccountType;
import com.plaid.client.model.AssetReportAccountBalance;
import com.plaid.client.model.AssetReportInvestments;
import com.plaid.client.model.AssetReportTransaction;
import com.plaid.client.model.HistoricalBalance;
import com.plaid.client.model.Owner;
import com.plaid.client.model.OwnershipType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Asset information about an account")
public class AccountAssets {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_BALANCES = "balances";
    @SerializedName(value="balances")
    private AssetReportAccountBalance balances;
    public static final String SERIALIZED_NAME_MASK = "mask";
    @SerializedName(value="mask")
    private String mask;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_OFFICIAL_NAME = "official_name";
    @SerializedName(value="official_name")
    private String officialName;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private AccountType type;
    public static final String SERIALIZED_NAME_SUBTYPE = "subtype";
    @SerializedName(value="subtype")
    private AccountSubtype subtype;
    public static final String SERIALIZED_NAME_VERIFICATION_STATUS = "verification_status";
    @SerializedName(value="verification_status")
    private VerificationStatusEnum verificationStatus;
    public static final String SERIALIZED_NAME_PERSISTENT_ACCOUNT_ID = "persistent_account_id";
    @SerializedName(value="persistent_account_id")
    private String persistentAccountId;
    public static final String SERIALIZED_NAME_HOLDER_CATEGORY = "holder_category";
    @SerializedName(value="holder_category")
    private AccountHolderCategory holderCategory;
    public static final String SERIALIZED_NAME_DAYS_AVAILABLE = "days_available";
    @SerializedName(value="days_available")
    private Double daysAvailable;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<AssetReportTransaction> transactions = new ArrayList<AssetReportTransaction>();
    public static final String SERIALIZED_NAME_INVESTMENTS = "investments";
    @SerializedName(value="investments")
    private AssetReportInvestments investments;
    public static final String SERIALIZED_NAME_OWNERS = "owners";
    @SerializedName(value="owners")
    private List<Owner> owners = new ArrayList<Owner>();
    public static final String SERIALIZED_NAME_OWNERSHIP_TYPE = "ownership_type";
    @SerializedName(value="ownership_type")
    private OwnershipType ownershipType;
    public static final String SERIALIZED_NAME_HISTORICAL_BALANCES = "historical_balances";
    @SerializedName(value="historical_balances")
    private List<HistoricalBalance> historicalBalances = new ArrayList<HistoricalBalance>();

    public AccountAssets accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for the account. This value will not change unless Plaid can't reconcile the account with the data returned by the financial institution. This may occur, for example, when the name of the account changes. If this happens a new `account_id` will be assigned to the account.  The `account_id` can also change if the `access_token` is deleted and the same credentials that were used to generate that `access_token` are used to generate a new `access_token` on a later date. In that case, the new `account_id` will be different from the old `account_id`.  If an account with a specific `account_id` disappears instead of changing, the account is likely closed. Closed accounts are not returned by the Plaid API.  Like all Plaid identifiers, the `account_id` is case sensitive.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AccountAssets balances(AssetReportAccountBalance balances) {
        this.balances = balances;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AssetReportAccountBalance getBalances() {
        return this.balances;
    }

    public void setBalances(AssetReportAccountBalance balances) {
        this.balances = balances;
    }

    public AccountAssets mask(String mask) {
        this.mask = mask;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The last 2-4 alphanumeric characters of an account's official account number. Note that the mask may be non-unique between an Item's accounts, and it may also not match the mask that the bank displays to the user.")
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public AccountAssets name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the account, either assigned by the user or by the financial institution itself")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccountAssets officialName(String officialName) {
        this.officialName = officialName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The official name of the account as given by the financial institution")
    public String getOfficialName() {
        return this.officialName;
    }

    public void setOfficialName(String officialName) {
        this.officialName = officialName;
    }

    public AccountAssets type(AccountType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AccountType getType() {
        return this.type;
    }

    public void setType(AccountType type) {
        this.type = type;
    }

    public AccountAssets subtype(AccountSubtype subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public AccountSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(AccountSubtype subtype) {
        this.subtype = subtype;
    }

    public AccountAssets verificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The current verification status of an Auth Item initiated through Automated or Manual micro-deposits.  Returned for Auth Items only.  `pending_automatic_verification`: The Item is pending automatic verification  `pending_manual_verification`: The Item is pending manual micro-deposit verification. Items remain in this state until the user successfully verifies the micro-deposit.  `automatically_verified`: The Item has successfully been automatically verified   `manually_verified`: The Item has successfully been manually verified  `verification_expired`: Plaid was unable to automatically verify the deposit within 7 calendar days and will no longer attempt to validate the Item. Users may retry by submitting their information again through Link.  `verification_failed`: The Item failed manual micro-deposit verification because the user exhausted all 3 verification attempts. Users may retry by submitting their information again through Link.  `database_matched`: The Item has successfully been verified using Plaid's data sources. Note: Database Match is currently a beta feature, please contact your account manager for more information.   ")
    public VerificationStatusEnum getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public AccountAssets persistentAccountId(String persistentAccountId) {
        this.persistentAccountId = persistentAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique and persistent identifier for accounts that can be used to trace multiple instances of the same account across different Items for depository accounts. This is currently an opt-in field and only supported for Chase Items.")
    public String getPersistentAccountId() {
        return this.persistentAccountId;
    }

    public void setPersistentAccountId(String persistentAccountId) {
        this.persistentAccountId = persistentAccountId;
    }

    public AccountAssets holderCategory(AccountHolderCategory holderCategory) {
        this.holderCategory = holderCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccountHolderCategory getHolderCategory() {
        return this.holderCategory;
    }

    public void setHolderCategory(AccountHolderCategory holderCategory) {
        this.holderCategory = holderCategory;
    }

    public AccountAssets daysAvailable(Double daysAvailable) {
        this.daysAvailable = daysAvailable;
        return this;
    }

    @ApiModelProperty(required=true, value="The duration of transaction history available for this Item, typically defined as the time since the date of the earliest transaction in that account.")
    public Double getDaysAvailable() {
        return this.daysAvailable;
    }

    public void setDaysAvailable(Double daysAvailable) {
        this.daysAvailable = daysAvailable;
    }

    public AccountAssets transactions(List<AssetReportTransaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public AccountAssets addTransactionsItem(AssetReportTransaction transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Transaction history associated with the account.")
    public List<AssetReportTransaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<AssetReportTransaction> transactions) {
        this.transactions = transactions;
    }

    public AccountAssets investments(AssetReportInvestments investments) {
        this.investments = investments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AssetReportInvestments getInvestments() {
        return this.investments;
    }

    public void setInvestments(AssetReportInvestments investments) {
        this.investments = investments;
    }

    public AccountAssets owners(List<Owner> owners) {
        this.owners = owners;
        return this;
    }

    public AccountAssets addOwnersItem(Owner ownersItem) {
        this.owners.add(ownersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Data returned by the financial institution about the account owner or owners.For business accounts, the name reported may be either the name of the individual or the name of the business, depending on the institution. Multiple owners on a single account will be represented in the same `owner` object, not in multiple owner objects within the array. In API versions 2018-05-22 and earlier, the `owners` object is not returned, and instead identity information is returned in the top level `identity` object. For more details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2019-05-29)")
    public List<Owner> getOwners() {
        return this.owners;
    }

    public void setOwners(List<Owner> owners) {
        this.owners = owners;
    }

    public AccountAssets ownershipType(OwnershipType ownershipType) {
        this.ownershipType = ownershipType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OwnershipType getOwnershipType() {
        return this.ownershipType;
    }

    public void setOwnershipType(OwnershipType ownershipType) {
        this.ownershipType = ownershipType;
    }

    public AccountAssets historicalBalances(List<HistoricalBalance> historicalBalances) {
        this.historicalBalances = historicalBalances;
        return this;
    }

    public AccountAssets addHistoricalBalancesItem(HistoricalBalance historicalBalancesItem) {
        this.historicalBalances.add(historicalBalancesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Calculated data about the historical balances on the account.")
    public List<HistoricalBalance> getHistoricalBalances() {
        return this.historicalBalances;
    }

    public void setHistoricalBalances(List<HistoricalBalance> historicalBalances) {
        this.historicalBalances = historicalBalances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountAssets accountAssets = (AccountAssets)o;
        return Objects.equals(this.accountId, accountAssets.accountId) && Objects.equals(this.balances, accountAssets.balances) && Objects.equals(this.mask, accountAssets.mask) && Objects.equals(this.name, accountAssets.name) && Objects.equals(this.officialName, accountAssets.officialName) && Objects.equals((Object)this.type, (Object)accountAssets.type) && Objects.equals((Object)this.subtype, (Object)accountAssets.subtype) && Objects.equals((Object)this.verificationStatus, (Object)accountAssets.verificationStatus) && Objects.equals(this.persistentAccountId, accountAssets.persistentAccountId) && Objects.equals((Object)this.holderCategory, (Object)accountAssets.holderCategory) && Objects.equals(this.daysAvailable, accountAssets.daysAvailable) && Objects.equals(this.transactions, accountAssets.transactions) && Objects.equals(this.investments, accountAssets.investments) && Objects.equals(this.owners, accountAssets.owners) && Objects.equals((Object)this.ownershipType, (Object)accountAssets.ownershipType) && Objects.equals(this.historicalBalances, accountAssets.historicalBalances);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.balances, this.mask, this.name, this.officialName, this.type, this.subtype, this.verificationStatus, this.persistentAccountId, this.holderCategory, this.daysAvailable, this.transactions, this.investments, this.owners, this.ownershipType, this.historicalBalances});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountAssets {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    officialName: ").append(this.toIndentedString(this.officialName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString((Object)this.subtype)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("    persistentAccountId: ").append(this.toIndentedString(this.persistentAccountId)).append("\n");
        sb.append("    holderCategory: ").append(this.toIndentedString((Object)this.holderCategory)).append("\n");
        sb.append("    daysAvailable: ").append(this.toIndentedString(this.daysAvailable)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    investments: ").append(this.toIndentedString(this.investments)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    ownershipType: ").append(this.toIndentedString((Object)this.ownershipType)).append("\n");
        sb.append("    historicalBalances: ").append(this.toIndentedString(this.historicalBalances)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerificationStatusEnum {
        AUTOMATICALLY_VERIFIED("automatically_verified"),
        PENDING_AUTOMATIC_VERIFICATION("pending_automatic_verification"),
        PENDING_MANUAL_VERIFICATION("pending_manual_verification"),
        MANUALLY_VERIFIED("manually_verified"),
        VERIFICATION_EXPIRED("verification_expired"),
        VERIFICATION_FAILED("verification_failed"),
        DATABASE_MATCHED("database_matched");

        private String value;

        private VerificationStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerificationStatusEnum fromValue(String value) {
            for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VerificationStatusEnum> {
            public void write(JsonWriter jsonWriter, VerificationStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerificationStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerificationStatusEnum.fromValue(value);
            }
        }
    }
}

