/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Enumerates the account subtypes that the application wishes for the user to be able to select from. For more details refer to Plaid documentation on account filters.")
public class AccountFilter {
    public static final String SERIALIZED_NAME_DEPOSITORY = "depository";
    @SerializedName(value="depository")
    private List<String> depository = null;
    public static final String SERIALIZED_NAME_CREDIT = "credit";
    @SerializedName(value="credit")
    private List<String> credit = null;
    public static final String SERIALIZED_NAME_LOAN = "loan";
    @SerializedName(value="loan")
    private List<String> loan = null;
    public static final String SERIALIZED_NAME_INVESTMENT = "investment";
    @SerializedName(value="investment")
    private List<String> investment = null;

    public AccountFilter depository(List<String> depository) {
        this.depository = depository;
        return this;
    }

    public AccountFilter addDepositoryItem(String depositoryItem) {
        if (this.depository == null) {
            this.depository = new ArrayList<String>();
        }
        this.depository.add(depositoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of account subtypes to be filtered.")
    public List<String> getDepository() {
        return this.depository;
    }

    public void setDepository(List<String> depository) {
        this.depository = depository;
    }

    public AccountFilter credit(List<String> credit) {
        this.credit = credit;
        return this;
    }

    public AccountFilter addCreditItem(String creditItem) {
        if (this.credit == null) {
            this.credit = new ArrayList<String>();
        }
        this.credit.add(creditItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of account subtypes to be filtered.")
    public List<String> getCredit() {
        return this.credit;
    }

    public void setCredit(List<String> credit) {
        this.credit = credit;
    }

    public AccountFilter loan(List<String> loan) {
        this.loan = loan;
        return this;
    }

    public AccountFilter addLoanItem(String loanItem) {
        if (this.loan == null) {
            this.loan = new ArrayList<String>();
        }
        this.loan.add(loanItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of account subtypes to be filtered.")
    public List<String> getLoan() {
        return this.loan;
    }

    public void setLoan(List<String> loan) {
        this.loan = loan;
    }

    public AccountFilter investment(List<String> investment) {
        this.investment = investment;
        return this;
    }

    public AccountFilter addInvestmentItem(String investmentItem) {
        if (this.investment == null) {
            this.investment = new ArrayList<String>();
        }
        this.investment.add(investmentItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of account subtypes to be filtered.")
    public List<String> getInvestment() {
        return this.investment;
    }

    public void setInvestment(List<String> investment) {
        this.investment = investment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountFilter accountFilter = (AccountFilter)o;
        return Objects.equals(this.depository, accountFilter.depository) && Objects.equals(this.credit, accountFilter.credit) && Objects.equals(this.loan, accountFilter.loan) && Objects.equals(this.investment, accountFilter.investment);
    }

    public int hashCode() {
        return Objects.hash(this.depository, this.credit, this.loan, this.investment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountFilter {\n");
        sb.append("    depository: ").append(this.toIndentedString(this.depository)).append("\n");
        sb.append("    credit: ").append(this.toIndentedString(this.credit)).append("\n");
        sb.append("    loan: ").append(this.toIndentedString(this.loan)).append("\n");
        sb.append("    investment: ").append(this.toIndentedString(this.investment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

