/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityDocumentUpload;
import com.plaid.client.model.Owner;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class AccountIdentityDocumentUploadAllOf {
    public static final String SERIALIZED_NAME_OWNERS = "owners";
    @SerializedName(value="owners")
    private List<Owner> owners = new ArrayList<Owner>();
    public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
    @SerializedName(value="documents")
    private List<IdentityDocumentUpload> documents = null;

    public AccountIdentityDocumentUploadAllOf owners(List<Owner> owners) {
        this.owners = owners;
        return this;
    }

    public AccountIdentityDocumentUploadAllOf addOwnersItem(Owner ownersItem) {
        this.owners.add(ownersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Data returned by the financial institution about the account owner or owners. Only returned by Identity or Assets endpoints. For business accounts, the name reported may be either the name of the individual or the name of the business, depending on the institution; detecting whether the linked account is a business account is not currently supported. Multiple owners on a single account will be represented in the same `owner` object, not in multiple owner objects within the array. In API versions 2018-05-22 and earlier, the `owners` object is not returned, and instead identity information is returned in the top level `identity` object. For more details, see [Plaid API versioning](https://plaid.com/docs/api/versioning/#version-2019-05-29)")
    public List<Owner> getOwners() {
        return this.owners;
    }

    public void setOwners(List<Owner> owners) {
        this.owners = owners;
    }

    public AccountIdentityDocumentUploadAllOf documents(List<IdentityDocumentUpload> documents) {
        this.documents = documents;
        return this;
    }

    public AccountIdentityDocumentUploadAllOf addDocumentsItem(IdentityDocumentUpload documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<IdentityDocumentUpload>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of document with which the Identity data is derived from.")
    public List<IdentityDocumentUpload> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<IdentityDocumentUpload> documents) {
        this.documents = documents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountIdentityDocumentUploadAllOf accountIdentityDocumentUploadAllOf = (AccountIdentityDocumentUploadAllOf)o;
        return Objects.equals(this.owners, accountIdentityDocumentUploadAllOf.owners) && Objects.equals(this.documents, accountIdentityDocumentUploadAllOf.documents);
    }

    public int hashCode() {
        return Objects.hash(this.owners, this.documents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountIdentityDocumentUploadAllOf {\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

