/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.AccountBalance;
import com.plaid.client.model.AccountHolderCategory;
import com.plaid.client.model.AccountSubtype;
import com.plaid.client.model.AccountType;
import com.plaid.client.model.AccountVerificationInsights;
import com.plaid.client.model.AddressMatchScore;
import com.plaid.client.model.EmailAddressMatchScore;
import com.plaid.client.model.NameMatchScore;
import com.plaid.client.model.PhoneNumberMatchScore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Identity match scores for an account")
public class AccountIdentityMatchScore {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_BALANCES = "balances";
    @SerializedName(value="balances")
    private AccountBalance balances;
    public static final String SERIALIZED_NAME_MASK = "mask";
    @SerializedName(value="mask")
    private String mask;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_OFFICIAL_NAME = "official_name";
    @SerializedName(value="official_name")
    private String officialName;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private AccountType type;
    public static final String SERIALIZED_NAME_SUBTYPE = "subtype";
    @SerializedName(value="subtype")
    private AccountSubtype subtype;
    public static final String SERIALIZED_NAME_VERIFICATION_STATUS = "verification_status";
    @SerializedName(value="verification_status")
    private VerificationStatusEnum verificationStatus;
    public static final String SERIALIZED_NAME_VERIFICATION_INSIGHTS = "verification_insights";
    @SerializedName(value="verification_insights")
    private AccountVerificationInsights verificationInsights;
    public static final String SERIALIZED_NAME_PERSISTENT_ACCOUNT_ID = "persistent_account_id";
    @SerializedName(value="persistent_account_id")
    private String persistentAccountId;
    public static final String SERIALIZED_NAME_HOLDER_CATEGORY = "holder_category";
    @SerializedName(value="holder_category")
    private AccountHolderCategory holderCategory;
    public static final String SERIALIZED_NAME_LEGAL_NAME = "legal_name";
    @SerializedName(value="legal_name")
    private NameMatchScore legalName;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private PhoneNumberMatchScore phoneNumber;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private EmailAddressMatchScore emailAddress;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private AddressMatchScore address;

    public AccountIdentityMatchScore accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for the account. This value will not change unless Plaid can't reconcile the account with the data returned by the financial institution. This may occur, for example, when the name of the account changes. If this happens a new `account_id` will be assigned to the account.  The `account_id` can also change if the `access_token` is deleted and the same credentials that were used to generate that `access_token` are used to generate a new `access_token` on a later date. In that case, the new `account_id` will be different from the old `account_id`.  If an account with a specific `account_id` disappears instead of changing, the account is likely closed. Closed accounts are not returned by the Plaid API.  Like all Plaid identifiers, the `account_id` is case sensitive.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AccountIdentityMatchScore balances(AccountBalance balances) {
        this.balances = balances;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AccountBalance getBalances() {
        return this.balances;
    }

    public void setBalances(AccountBalance balances) {
        this.balances = balances;
    }

    public AccountIdentityMatchScore mask(String mask) {
        this.mask = mask;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The last 2-4 alphanumeric characters of an account's official account number. Note that the mask may be non-unique between an Item's accounts, and it may also not match the mask that the bank displays to the user.")
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public AccountIdentityMatchScore name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the account, either assigned by the user or by the financial institution itself")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccountIdentityMatchScore officialName(String officialName) {
        this.officialName = officialName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The official name of the account as given by the financial institution")
    public String getOfficialName() {
        return this.officialName;
    }

    public void setOfficialName(String officialName) {
        this.officialName = officialName;
    }

    public AccountIdentityMatchScore type(AccountType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AccountType getType() {
        return this.type;
    }

    public void setType(AccountType type) {
        this.type = type;
    }

    public AccountIdentityMatchScore subtype(AccountSubtype subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public AccountSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(AccountSubtype subtype) {
        this.subtype = subtype;
    }

    public AccountIdentityMatchScore verificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The current verification status of an Auth Item initiated through Automated or Manual micro-deposits.  Returned for Auth Items only.  `pending_automatic_verification`: The Item is pending automatic verification  `pending_manual_verification`: The Item is pending manual micro-deposit verification. Items remain in this state until the user successfully verifies the micro-deposit.  `automatically_verified`: The Item has successfully been automatically verified   `manually_verified`: The Item has successfully been manually verified  `verification_expired`: Plaid was unable to automatically verify the deposit within 7 calendar days and will no longer attempt to validate the Item. Users may retry by submitting their information again through Link.  `verification_failed`: The Item failed manual micro-deposit verification because the user exhausted all 3 verification attempts. Users may retry by submitting their information again through Link.  `database_matched`: The Item has successfully been verified using Plaid's data sources.  `database_insights_pass`: The Item's ACH numbers have been verified using Plaid's data sources and have strong signal for being valid. Note: Database Insights is currently a beta feature, please contact your account manager for more information.  `database_insights_pass_with_caution`: The Item's ACH numbers have been verified using Plaid's data sources and have some signal for being valid. Note: Database Insights is currently a beta feature, please contact your account manager for more information.  `database_insights_fail`:  The Item's ACH numbers have been verified using Plaid's data sources and have signal for being invalid and/or have no signal for being valid. Note: Database Insights is currently a beta feature, please contact your account manager for more information.   ")
    public VerificationStatusEnum getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public AccountIdentityMatchScore verificationInsights(AccountVerificationInsights verificationInsights) {
        this.verificationInsights = verificationInsights;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccountVerificationInsights getVerificationInsights() {
        return this.verificationInsights;
    }

    public void setVerificationInsights(AccountVerificationInsights verificationInsights) {
        this.verificationInsights = verificationInsights;
    }

    public AccountIdentityMatchScore persistentAccountId(String persistentAccountId) {
        this.persistentAccountId = persistentAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique and persistent identifier for accounts that can be used to trace multiple instances of the same account across different Items for depository accounts. This is currently only supported for Chase Items. Because Chase accounts have a different account number each time they are linked, this field may be used instead of the account number to uniquely identify a Chase account across multiple Items for payments use cases, helping to reduce duplicate Items or attempted fraud. In Sandbox, this field may be populated for any account; in Production, it will only be populated for Chase accounts.")
    public String getPersistentAccountId() {
        return this.persistentAccountId;
    }

    public void setPersistentAccountId(String persistentAccountId) {
        this.persistentAccountId = persistentAccountId;
    }

    public AccountIdentityMatchScore holderCategory(AccountHolderCategory holderCategory) {
        this.holderCategory = holderCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccountHolderCategory getHolderCategory() {
        return this.holderCategory;
    }

    public void setHolderCategory(AccountHolderCategory holderCategory) {
        this.holderCategory = holderCategory;
    }

    public AccountIdentityMatchScore legalName(NameMatchScore legalName) {
        this.legalName = legalName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NameMatchScore getLegalName() {
        return this.legalName;
    }

    public void setLegalName(NameMatchScore legalName) {
        this.legalName = legalName;
    }

    public AccountIdentityMatchScore phoneNumber(PhoneNumberMatchScore phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PhoneNumberMatchScore getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(PhoneNumberMatchScore phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public AccountIdentityMatchScore emailAddress(EmailAddressMatchScore emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EmailAddressMatchScore getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(EmailAddressMatchScore emailAddress) {
        this.emailAddress = emailAddress;
    }

    public AccountIdentityMatchScore address(AddressMatchScore address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AddressMatchScore getAddress() {
        return this.address;
    }

    public void setAddress(AddressMatchScore address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountIdentityMatchScore accountIdentityMatchScore = (AccountIdentityMatchScore)o;
        return Objects.equals(this.accountId, accountIdentityMatchScore.accountId) && Objects.equals(this.balances, accountIdentityMatchScore.balances) && Objects.equals(this.mask, accountIdentityMatchScore.mask) && Objects.equals(this.name, accountIdentityMatchScore.name) && Objects.equals(this.officialName, accountIdentityMatchScore.officialName) && Objects.equals((Object)this.type, (Object)accountIdentityMatchScore.type) && Objects.equals((Object)this.subtype, (Object)accountIdentityMatchScore.subtype) && Objects.equals((Object)this.verificationStatus, (Object)accountIdentityMatchScore.verificationStatus) && Objects.equals(this.verificationInsights, accountIdentityMatchScore.verificationInsights) && Objects.equals(this.persistentAccountId, accountIdentityMatchScore.persistentAccountId) && Objects.equals((Object)this.holderCategory, (Object)accountIdentityMatchScore.holderCategory) && Objects.equals(this.legalName, accountIdentityMatchScore.legalName) && Objects.equals(this.phoneNumber, accountIdentityMatchScore.phoneNumber) && Objects.equals(this.emailAddress, accountIdentityMatchScore.emailAddress) && Objects.equals(this.address, accountIdentityMatchScore.address);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.balances, this.mask, this.name, this.officialName, this.type, this.subtype, this.verificationStatus, this.verificationInsights, this.persistentAccountId, this.holderCategory, this.legalName, this.phoneNumber, this.emailAddress, this.address});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountIdentityMatchScore {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    officialName: ").append(this.toIndentedString(this.officialName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString((Object)this.subtype)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("    verificationInsights: ").append(this.toIndentedString(this.verificationInsights)).append("\n");
        sb.append("    persistentAccountId: ").append(this.toIndentedString(this.persistentAccountId)).append("\n");
        sb.append("    holderCategory: ").append(this.toIndentedString((Object)this.holderCategory)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerificationStatusEnum {
        AUTOMATICALLY_VERIFIED("automatically_verified"),
        PENDING_AUTOMATIC_VERIFICATION("pending_automatic_verification"),
        PENDING_MANUAL_VERIFICATION("pending_manual_verification"),
        MANUALLY_VERIFIED("manually_verified"),
        VERIFICATION_EXPIRED("verification_expired"),
        VERIFICATION_FAILED("verification_failed"),
        DATABASE_MATCHED("database_matched"),
        DATABASE_INSIGHTS_PASS("database_insights_pass"),
        DATABASE_INSIGHTS_PASS_WITH_CAUTION("database_insights_pass_with_caution"),
        DATABASE_INSIGHTS_FAIL("database_insights_fail");

        private String value;

        private VerificationStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerificationStatusEnum fromValue(String value) {
            for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VerificationStatusEnum> {
            public void write(JsonWriter jsonWriter, VerificationStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerificationStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerificationStatusEnum.fromValue(value);
            }
        }
    }
}

