/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Status information about the account and routing number in the Plaid network.")
public class AccountVerificationInsightsNetworkStatus {
    public static final String SERIALIZED_NAME_HAS_NUMBERS_MATCH = "has_numbers_match";
    @SerializedName(value="has_numbers_match")
    private Boolean hasNumbersMatch;
    public static final String SERIALIZED_NAME_IS_NUMBERS_MATCH_VERIFIED = "is_numbers_match_verified";
    @SerializedName(value="is_numbers_match_verified")
    private Boolean isNumbersMatchVerified;

    public AccountVerificationInsightsNetworkStatus hasNumbersMatch(Boolean hasNumbersMatch) {
        this.hasNumbersMatch = hasNumbersMatch;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether we found at least one matching account for the ACH account and routing number.")
    public Boolean getHasNumbersMatch() {
        return this.hasNumbersMatch;
    }

    public void setHasNumbersMatch(Boolean hasNumbersMatch) {
        this.hasNumbersMatch = hasNumbersMatch;
    }

    public AccountVerificationInsightsNetworkStatus isNumbersMatchVerified(Boolean isNumbersMatchVerified) {
        this.isNumbersMatchVerified = isNumbersMatchVerified;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if at least one matching account for the ACH account and routing number is already verified.")
    public Boolean getIsNumbersMatchVerified() {
        return this.isNumbersMatchVerified;
    }

    public void setIsNumbersMatchVerified(Boolean isNumbersMatchVerified) {
        this.isNumbersMatchVerified = isNumbersMatchVerified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountVerificationInsightsNetworkStatus accountVerificationInsightsNetworkStatus = (AccountVerificationInsightsNetworkStatus)o;
        return Objects.equals(this.hasNumbersMatch, accountVerificationInsightsNetworkStatus.hasNumbersMatch) && Objects.equals(this.isNumbersMatchVerified, accountVerificationInsightsNetworkStatus.isNumbersMatchVerified);
    }

    public int hashCode() {
        return Objects.hash(this.hasNumbersMatch, this.isNumbersMatchVerified);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountVerificationInsightsNetworkStatus {\n");
        sb.append("    hasNumbersMatch: ").append(this.toIndentedString(this.hasNumbersMatch)).append("\n");
        sb.append("    isNumbersMatchVerified: ").append(this.toIndentedString(this.isNumbersMatchVerified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

