/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountsBalanceGetRequestOptions;
import com.plaid.client.model.AccountsBalanceGetRequestPaymentDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AccountsBalanceGetRequest defines the request schema for `/accounts/balance/get`")
public class AccountsBalanceGetRequest {
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private AccountsBalanceGetRequestOptions options;
    public static final String SERIALIZED_NAME_PAYMENT_DETAILS = "payment_details";
    @SerializedName(value="payment_details")
    private AccountsBalanceGetRequestPaymentDetails paymentDetails;

    public AccountsBalanceGetRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public AccountsBalanceGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public AccountsBalanceGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AccountsBalanceGetRequest options(AccountsBalanceGetRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccountsBalanceGetRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(AccountsBalanceGetRequestOptions options) {
        this.options = options;
    }

    public AccountsBalanceGetRequest paymentDetails(AccountsBalanceGetRequestPaymentDetails paymentDetails) {
        this.paymentDetails = paymentDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccountsBalanceGetRequestPaymentDetails getPaymentDetails() {
        return this.paymentDetails;
    }

    public void setPaymentDetails(AccountsBalanceGetRequestPaymentDetails paymentDetails) {
        this.paymentDetails = paymentDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountsBalanceGetRequest accountsBalanceGetRequest = (AccountsBalanceGetRequest)o;
        return Objects.equals(this.accessToken, accountsBalanceGetRequest.accessToken) && Objects.equals(this.secret, accountsBalanceGetRequest.secret) && Objects.equals(this.clientId, accountsBalanceGetRequest.clientId) && Objects.equals(this.options, accountsBalanceGetRequest.options) && Objects.equals(this.paymentDetails, accountsBalanceGetRequest.paymentDetails);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.secret, this.clientId, this.options, this.paymentDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountsBalanceGetRequest {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    paymentDetails: ").append(this.toIndentedString(this.paymentDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

