/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Optional parameters to `/accounts/balance/get`.")
public class AccountsBalanceGetRequestOptions {
    public static final String SERIALIZED_NAME_ACCOUNT_IDS = "account_ids";
    @SerializedName(value="account_ids")
    private List<String> accountIds = null;
    public static final String SERIALIZED_NAME_MIN_LAST_UPDATED_DATETIME = "min_last_updated_datetime";
    @SerializedName(value="min_last_updated_datetime")
    private OffsetDateTime minLastUpdatedDatetime;

    public AccountsBalanceGetRequestOptions accountIds(List<String> accountIds) {
        this.accountIds = accountIds;
        return this;
    }

    public AccountsBalanceGetRequestOptions addAccountIdsItem(String accountIdsItem) {
        if (this.accountIds == null) {
            this.accountIds = new ArrayList<String>();
        }
        this.accountIds.add(accountIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of `account_ids` to retrieve for the Item. The default value is `null`.  Note: An error will be returned if a provided `account_id` is not associated with the Item.")
    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(List<String> accountIds) {
        this.accountIds = accountIds;
    }

    public AccountsBalanceGetRequestOptions minLastUpdatedDatetime(OffsetDateTime minLastUpdatedDatetime) {
        this.minLastUpdatedDatetime = minLastUpdatedDatetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the oldest acceptable balance when making a request to `/accounts/balance/get`.  This field is only necessary when the institution is `ins_128026` (Capital One), *and* one or more account types being requested is a non-depository account (such as a credit card) as Capital One does not provide real-time balance for non-depository accounts. In this case, a value must be provided or an `INVALID_REQUEST` error with the code of `INVALID_FIELD` will be returned. For all other institutions, as well as for depository accounts at Capital One (including all checking and savings accounts) this field is ignored and real-time balance information will be fetched.  If this field is not ignored, and no acceptable balance is available, an `INVALID_RESULT` error with the code `LAST_UPDATED_DATETIME_OUT_OF_RANGE` will be returned.")
    public OffsetDateTime getMinLastUpdatedDatetime() {
        return this.minLastUpdatedDatetime;
    }

    public void setMinLastUpdatedDatetime(OffsetDateTime minLastUpdatedDatetime) {
        this.minLastUpdatedDatetime = minLastUpdatedDatetime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountsBalanceGetRequestOptions accountsBalanceGetRequestOptions = (AccountsBalanceGetRequestOptions)o;
        return Objects.equals(this.accountIds, accountsBalanceGetRequestOptions.accountIds) && Objects.equals(this.minLastUpdatedDatetime, accountsBalanceGetRequestOptions.minLastUpdatedDatetime);
    }

    public int hashCode() {
        return Objects.hash(this.accountIds, this.minLastUpdatedDatetime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountsBalanceGetRequestOptions {\n");
        sb.append("    accountIds: ").append(this.toIndentedString(this.accountIds)).append("\n");
        sb.append("    minLastUpdatedDatetime: ").append(this.toIndentedString(this.minLastUpdatedDatetime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

