/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="To enable Balance Plus (beta), send this object as part of the `/accounts/balance/get` request. Only available to customers participating in the Balance Plus beta program; to enroll in the beta, contact your account manager. If this object is present in the request, the [`payment_risk_assessment`](https://plaid.com/docs/balance/balance-plus/#accounts-balance-get-response-payment-risk-assessment-risk-level) object will be present in the response.")
public class AccountsBalanceGetRequestPaymentDetails {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_CLIENT_TRANSACTION_ID = "client_transaction_id";
    @SerializedName(value="client_transaction_id")
    private String clientTransactionId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_BALANCE_THRESHOLD_PERCENTAGE = "balance_threshold_percentage";
    @SerializedName(value="balance_threshold_percentage")
    private Integer balanceThresholdPercentage = 90;
    public static final String SERIALIZED_NAME_REQUIRES_REAL_TIME_BALANCE_REFRESH = "requires_real_time_balance_refresh";
    @SerializedName(value="requires_real_time_balance_refresh")
    private Boolean requiresRealTimeBalanceRefresh = false;

    public AccountsBalanceGetRequestPaymentDetails accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `account_id` of the account that is the funding source for the proposed transaction. The `account_id` is returned in the `/accounts/get` endpoint as well as the [`onSuccess`](/docs/link/ios/#link-ios-onsuccess-linkSuccess-metadata-accounts-id) callback metadata.  This will return an [`INVALID_ACCOUNT_ID`](/docs/errors/invalid-input/#invalid_account_id) error if the account has been removed at the bank or if the `account_id` is no longer valid.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AccountsBalanceGetRequestPaymentDetails clientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID that you would like to use to refer to this transaction. For your convenience mapping your internal data, you could use your internal identifier for this transaction.")
    public String getClientTransactionId() {
        return this.clientTransactionId;
    }

    public void setClientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
    }

    public AccountsBalanceGetRequestPaymentDetails amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The transaction amount, in USD (e.g. `102.05`)")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public AccountsBalanceGetRequestPaymentDetails balanceThresholdPercentage(Integer balanceThresholdPercentage) {
        this.balanceThresholdPercentage = balanceThresholdPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the `amount` multiplied by the `balance_threshold_percentage` (as a percentage) exceeds the balance in the account, then [`payment_risk_assessment.exceeds_balance_threshold`](https://plaid.com/docs/balance/balance-plus/#accounts-balance-get-response-payment-risk-assessment-exceeds-balance-threshold) in the response will be true, otherwise, it will be false. For example, if the `amount` is 200 and the `balance_threshold_percentage` is 90, then the account balance must be at least 180 for `exceeds_balance_threshold` to be false.   By default, the available balance will be used for this calculation; if it cannot be obtained, the current balance will be used.   This field is particularly useful for customers using indirect Items and who do not have direct access to raw balance data. ")
    public Integer getBalanceThresholdPercentage() {
        return this.balanceThresholdPercentage;
    }

    public void setBalanceThresholdPercentage(Integer balanceThresholdPercentage) {
        this.balanceThresholdPercentage = balanceThresholdPercentage;
    }

    public AccountsBalanceGetRequestPaymentDetails requiresRealTimeBalanceRefresh(Boolean requiresRealTimeBalanceRefresh) {
        this.requiresRealTimeBalanceRefresh = requiresRealTimeBalanceRefresh;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean that determines whether the balance has to be refreshed in real time as part of the API call when using Balance Plus. Setting this to field to `true` will result in more recent balances, but latency may be up to 30 seconds or more. If making a regular (non-Balance Plus) Balance call, without the `payment_details` object present, `/accounts/balance/get` will always return real-time balances.")
    public Boolean getRequiresRealTimeBalanceRefresh() {
        return this.requiresRealTimeBalanceRefresh;
    }

    public void setRequiresRealTimeBalanceRefresh(Boolean requiresRealTimeBalanceRefresh) {
        this.requiresRealTimeBalanceRefresh = requiresRealTimeBalanceRefresh;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountsBalanceGetRequestPaymentDetails accountsBalanceGetRequestPaymentDetails = (AccountsBalanceGetRequestPaymentDetails)o;
        return Objects.equals(this.accountId, accountsBalanceGetRequestPaymentDetails.accountId) && Objects.equals(this.clientTransactionId, accountsBalanceGetRequestPaymentDetails.clientTransactionId) && Objects.equals(this.amount, accountsBalanceGetRequestPaymentDetails.amount) && Objects.equals(this.balanceThresholdPercentage, accountsBalanceGetRequestPaymentDetails.balanceThresholdPercentage) && Objects.equals(this.requiresRealTimeBalanceRefresh, accountsBalanceGetRequestPaymentDetails.requiresRealTimeBalanceRefresh);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.clientTransactionId, this.amount, this.balanceThresholdPercentage, this.requiresRealTimeBalanceRefresh);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountsBalanceGetRequestPaymentDetails {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    clientTransactionId: ").append(this.toIndentedString(this.clientTransactionId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceThresholdPercentage: ").append(this.toIndentedString(this.balanceThresholdPercentage)).append("\n");
        sb.append("    requiresRealTimeBalanceRefresh: ").append(this.toIndentedString(this.requiresRealTimeBalanceRefresh)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

