/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BalancePlusAttributes;
import com.plaid.client.model.BalancePlusRiskLevel;
import com.plaid.client.model.RiskReason;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Provides a detailed risk assessment for the requested transaction. For this field to be returned, the client must be enrolled in the Balance Plus beta program and the [`payment_details`](http://plaid.com/docs/balance/balance-plus/#accounts-balance-get-request-payment-details) object must have been sent in the request.")
public class AccountsBalanceGetResponsePaymentRiskAssessment {
    public static final String SERIALIZED_NAME_RISK_LEVEL = "risk_level";
    @SerializedName(value="risk_level")
    private BalancePlusRiskLevel riskLevel;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private BalancePlusAttributes attributes;
    public static final String SERIALIZED_NAME_SCORE = "score";
    @SerializedName(value="score")
    private Integer score;
    public static final String SERIALIZED_NAME_BALANCE_LAST_UPDATED = "balance_last_updated";
    @SerializedName(value="balance_last_updated")
    private OffsetDateTime balanceLastUpdated;
    public static final String SERIALIZED_NAME_RISK_REASONS = "risk_reasons";
    @SerializedName(value="risk_reasons")
    private List<RiskReason> riskReasons = null;
    public static final String SERIALIZED_NAME_EXCEEDS_BALANCE_THRESHOLD = "exceeds_balance_threshold";
    @SerializedName(value="exceeds_balance_threshold")
    private Boolean exceedsBalanceThreshold;

    public AccountsBalanceGetResponsePaymentRiskAssessment riskLevel(BalancePlusRiskLevel riskLevel) {
        this.riskLevel = riskLevel;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BalancePlusRiskLevel getRiskLevel() {
        return this.riskLevel;
    }

    public void setRiskLevel(BalancePlusRiskLevel riskLevel) {
        this.riskLevel = riskLevel;
    }

    public AccountsBalanceGetResponsePaymentRiskAssessment attributes(BalancePlusAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BalancePlusAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(BalancePlusAttributes attributes) {
        this.attributes = attributes;
    }

    public AccountsBalanceGetResponsePaymentRiskAssessment score(Integer score) {
        this.score = score;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A risk score ranging from 1-99, reflecting the likelihood of ACH debit return. A higher score indicates a greater risk of return, often due to overdrawn accounts or account ineligibility to receive ACH transactions. Typical return codes include \"R01\", \"R02\", \"R03\", \"R04\", \"R06\", \"R08\", \"R09\", \"R13\", \"R16\", \"R17\", \"R20\", \"R23\", etc., with a turnaround of 2 banking days.")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public AccountsBalanceGetResponsePaymentRiskAssessment balanceLastUpdated(OffsetDateTime balanceLastUpdated) {
        this.balanceLastUpdated = balanceLastUpdated;
        return this;
    }

    @ApiModelProperty(required=true, value="Timestamp of the last successful balance update, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public OffsetDateTime getBalanceLastUpdated() {
        return this.balanceLastUpdated;
    }

    public void setBalanceLastUpdated(OffsetDateTime balanceLastUpdated) {
        this.balanceLastUpdated = balanceLastUpdated;
    }

    public AccountsBalanceGetResponsePaymentRiskAssessment riskReasons(List<RiskReason> riskReasons) {
        this.riskReasons = riskReasons;
        return this;
    }

    public AccountsBalanceGetResponsePaymentRiskAssessment addRiskReasonsItem(RiskReason riskReasonsItem) {
        if (this.riskReasons == null) {
            this.riskReasons = new ArrayList<RiskReason>();
        }
        this.riskReasons.add(riskReasonsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of objects, each representing a specific reason contributing to the risk assessment of an ACH transaction. This field is only supplied for transactions classified as `HIGH`, `MEDIUM-HIGH`, or `MEDIUM` risk.")
    public List<RiskReason> getRiskReasons() {
        return this.riskReasons;
    }

    public void setRiskReasons(List<RiskReason> riskReasons) {
        this.riskReasons = riskReasons;
    }

    public AccountsBalanceGetResponsePaymentRiskAssessment exceedsBalanceThreshold(Boolean exceedsBalanceThreshold) {
        this.exceedsBalanceThreshold = exceedsBalanceThreshold;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the proposed transaction exceeds the balance threshold set in the request. `true` indicates higher risk; `false` indicates lower risk. If the `amount` multiplied by the `balance_threshold_percentage` (as a percentage) exceeds the balance in the account, then `exceeds_balance_threshold` will be true, otherwise, it will be false. For example, if the `amount` is 200 and the `balance_threshold_percentage` is 90, then the account balance must be at least 180 for `exceeds_balance_threshold` to be false.   By default, the available balance will be used for this calculation; if it cannot be obtained, the current balance will be used.   This field is particularly useful for customers using indirect Items and who do not have direct access to raw balance data. ")
    public Boolean getExceedsBalanceThreshold() {
        return this.exceedsBalanceThreshold;
    }

    public void setExceedsBalanceThreshold(Boolean exceedsBalanceThreshold) {
        this.exceedsBalanceThreshold = exceedsBalanceThreshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountsBalanceGetResponsePaymentRiskAssessment accountsBalanceGetResponsePaymentRiskAssessment = (AccountsBalanceGetResponsePaymentRiskAssessment)o;
        return Objects.equals((Object)this.riskLevel, (Object)accountsBalanceGetResponsePaymentRiskAssessment.riskLevel) && Objects.equals(this.attributes, accountsBalanceGetResponsePaymentRiskAssessment.attributes) && Objects.equals(this.score, accountsBalanceGetResponsePaymentRiskAssessment.score) && Objects.equals(this.balanceLastUpdated, accountsBalanceGetResponsePaymentRiskAssessment.balanceLastUpdated) && Objects.equals(this.riskReasons, accountsBalanceGetResponsePaymentRiskAssessment.riskReasons) && Objects.equals(this.exceedsBalanceThreshold, accountsBalanceGetResponsePaymentRiskAssessment.exceedsBalanceThreshold);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.riskLevel, this.attributes, this.score, this.balanceLastUpdated, this.riskReasons, this.exceedsBalanceThreshold});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountsBalanceGetResponsePaymentRiskAssessment {\n");
        sb.append("    riskLevel: ").append(this.toIndentedString((Object)this.riskLevel)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    balanceLastUpdated: ").append(this.toIndentedString(this.balanceLastUpdated)).append("\n");
        sb.append("    riskReasons: ").append(this.toIndentedString(this.riskReasons)).append("\n");
        sb.append("    exceedsBalanceThreshold: ").append(this.toIndentedString(this.exceedsBalanceThreshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

