/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountBase;
import com.plaid.client.model.AccountsBalanceGetResponsePaymentRiskAssessment;
import com.plaid.client.model.Item;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AccountsGetResponse defines the response schema for `/accounts/get` and `/accounts/balance/get`.")
public class AccountsGetResponse {
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<AccountBase> accounts = new ArrayList<AccountBase>();
    public static final String SERIALIZED_NAME_ITEM = "item";
    @SerializedName(value="item")
    private Item item;
    public static final String SERIALIZED_NAME_PAYMENT_RISK_ASSESSMENT = "payment_risk_assessment";
    @SerializedName(value="payment_risk_assessment")
    private AccountsBalanceGetResponsePaymentRiskAssessment paymentRiskAssessment;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public AccountsGetResponse accounts(List<AccountBase> accounts) {
        this.accounts = accounts;
        return this;
    }

    public AccountsGetResponse addAccountsItem(AccountBase accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of financial institution accounts associated with the Item. If `/accounts/balance/get` was called, each account will include real-time balance information.")
    public List<AccountBase> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountBase> accounts) {
        this.accounts = accounts;
    }

    public AccountsGetResponse item(Item item) {
        this.item = item;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public AccountsGetResponse paymentRiskAssessment(AccountsBalanceGetResponsePaymentRiskAssessment paymentRiskAssessment) {
        this.paymentRiskAssessment = paymentRiskAssessment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccountsBalanceGetResponsePaymentRiskAssessment getPaymentRiskAssessment() {
        return this.paymentRiskAssessment;
    }

    public void setPaymentRiskAssessment(AccountsBalanceGetResponsePaymentRiskAssessment paymentRiskAssessment) {
        this.paymentRiskAssessment = paymentRiskAssessment;
    }

    public AccountsGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountsGetResponse accountsGetResponse = (AccountsGetResponse)o;
        return Objects.equals(this.accounts, accountsGetResponse.accounts) && Objects.equals(this.item, accountsGetResponse.item) && Objects.equals(this.paymentRiskAssessment, accountsGetResponse.paymentRiskAssessment) && Objects.equals(this.requestId, accountsGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.item, this.paymentRiskAssessment, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountsGetResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    item: ").append(this.toIndentedString(this.item)).append("\n");
        sb.append("    paymentRiskAssessment: ").append(this.toIndentedString(this.paymentRiskAssessment)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

