/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ActionState;
import com.plaid.client.model.ActivityType;
import com.plaid.client.model.ScopesNullable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes a consent activity.")
public class Activity {
    public static final String SERIALIZED_NAME_ACTIVITY = "activity";
    @SerializedName(value="activity")
    private ActivityType activity;
    public static final String SERIALIZED_NAME_INITIATED_DATE = "initiated_date";
    @SerializedName(value="initiated_date")
    private LocalDate initiatedDate;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INITIATOR = "initiator";
    @SerializedName(value="initiator")
    private String initiator;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private ActionState state;
    public static final String SERIALIZED_NAME_TARGET_APPLICATION_ID = "target_application_id";
    @SerializedName(value="target_application_id")
    private String targetApplicationId;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private ScopesNullable scopes;

    public Activity activity(ActivityType activity) {
        this.activity = activity;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ActivityType getActivity() {
        return this.activity;
    }

    public void setActivity(ActivityType activity) {
        this.activity = activity;
    }

    public Activity initiatedDate(LocalDate initiatedDate) {
        this.initiatedDate = initiatedDate;
        return this;
    }

    @ApiModelProperty(example="Wed Jan 01 00:00:00 UTC 2020", required=true, value="The date this activity was initiated [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format in UTC.")
    public LocalDate getInitiatedDate() {
        return this.initiatedDate;
    }

    public void setInitiatedDate(LocalDate initiatedDate) {
        this.initiatedDate = initiatedDate;
    }

    public Activity id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the activity")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Activity initiator(String initiator) {
        this.initiator = initiator;
        return this;
    }

    @ApiModelProperty(required=true, value="Application ID of the client who initiated the activity.")
    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public Activity state(ActionState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ActionState getState() {
        return this.state;
    }

    public void setState(ActionState state) {
        this.state = state;
    }

    public Activity targetApplicationId(String targetApplicationId) {
        this.targetApplicationId = targetApplicationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This field will map to the application ID that is returned from /item/application/list, or provided to the institution in an oauth redirect.")
    public String getTargetApplicationId() {
        return this.targetApplicationId;
    }

    public void setTargetApplicationId(String targetApplicationId) {
        this.targetApplicationId = targetApplicationId;
    }

    public Activity scopes(ScopesNullable scopes) {
        this.scopes = scopes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ScopesNullable getScopes() {
        return this.scopes;
    }

    public void setScopes(ScopesNullable scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity activity = (Activity)o;
        return Objects.equals((Object)this.activity, (Object)activity.activity) && Objects.equals(this.initiatedDate, activity.initiatedDate) && Objects.equals(this.id, activity.id) && Objects.equals(this.initiator, activity.initiator) && Objects.equals((Object)this.state, (Object)activity.state) && Objects.equals(this.targetApplicationId, activity.targetApplicationId) && Objects.equals(this.scopes, activity.scopes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activity, this.initiatedDate, this.id, this.initiator, this.state, this.targetApplicationId, this.scopes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Activity {\n");
        sb.append("    activity: ").append(this.toIndentedString((Object)this.activity)).append("\n");
        sb.append("    initiatedDate: ").append(this.toIndentedString(this.initiatedDate)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    initiator: ").append(this.toIndentedString(this.initiator)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    targetApplicationId: ").append(this.toIndentedString(this.targetApplicationId)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

