/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Score found by matching address provided by the API with the address on the account at the financial institution. The score can range from 0 to 100 where 100 is a perfect match and 0 is a no match. If the account contains multiple owners, the maximum match score is filled.")
public class AddressMatchScore {
    public static final String SERIALIZED_NAME_SCORE = "score";
    @SerializedName(value="score")
    private Integer score;
    public static final String SERIALIZED_NAME_IS_POSTAL_CODE_MATCH = "is_postal_code_match";
    @SerializedName(value="is_postal_code_match")
    private Boolean isPostalCodeMatch;

    public AddressMatchScore score(Integer score) {
        this.score = score;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match score for address. 100 is a perfect match, 99-90 is a strong match, 89-70 is a partial match, anything below 70 is considered a weak match. Typically, the match threshold should be set to a score of 70 or higher. If the address is missing from either the API or financial institution, this is null.")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public AddressMatchScore isPostalCodeMatch(Boolean isPostalCodeMatch) {
        this.isPostalCodeMatch = isPostalCodeMatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="postal code was provided for both and was a match")
    public Boolean getIsPostalCodeMatch() {
        return this.isPostalCodeMatch;
    }

    public void setIsPostalCodeMatch(Boolean isPostalCodeMatch) {
        this.isPostalCodeMatch = isPostalCodeMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressMatchScore addressMatchScore = (AddressMatchScore)o;
        return Objects.equals(this.score, addressMatchScore.score) && Objects.equals(this.isPostalCodeMatch, addressMatchScore.isPostalCodeMatch);
    }

    public int hashCode() {
        return Objects.hash(this.score, this.isPostalCodeMatch);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressMatchScore {\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    isPostalCodeMatch: ").append(this.toIndentedString(this.isPostalCodeMatch)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

