/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata about the application")
public class Application {
    public static final String SERIALIZED_NAME_APPLICATION_ID = "application_id";
    @SerializedName(value="application_id")
    private String applicationId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DISPLAY_NAME = "display_name";
    @SerializedName(value="display_name")
    private String displayName;
    public static final String SERIALIZED_NAME_JOIN_DATE = "join_date";
    @SerializedName(value="join_date")
    private LocalDate joinDate;
    public static final String SERIALIZED_NAME_LOGO_URL = "logo_url";
    @SerializedName(value="logo_url")
    private String logoUrl;
    public static final String SERIALIZED_NAME_APPLICATION_URL = "application_url";
    @SerializedName(value="application_url")
    private String applicationUrl;
    public static final String SERIALIZED_NAME_REASON_FOR_ACCESS = "reason_for_access";
    @SerializedName(value="reason_for_access")
    private String reasonForAccess;
    public static final String SERIALIZED_NAME_USE_CASE = "use_case";
    @SerializedName(value="use_case")
    private String useCase;
    public static final String SERIALIZED_NAME_COMPANY_LEGAL_NAME = "company_legal_name";
    @SerializedName(value="company_legal_name")
    private String companyLegalName;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "country_code";
    @SerializedName(value="country_code")
    private String countryCode;

    public Application applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @ApiModelProperty(required=true, value="This field will map to the application ID that is returned from /item/application/list, or provided to the institution in an oauth redirect.")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public Application name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the application")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Application displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A human-readable name of the application for display purposes")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Application joinDate(LocalDate joinDate) {
        this.joinDate = joinDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date this application was granted production access at Plaid in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format in UTC.")
    public LocalDate getJoinDate() {
        return this.joinDate;
    }

    public void setJoinDate(LocalDate joinDate) {
        this.joinDate = joinDate;
    }

    public Application logoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A URL that links to the application logo image.")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public Application applicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The URL for the application's website")
    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public Application reasonForAccess(String reasonForAccess) {
        this.reasonForAccess = reasonForAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A string provided by the connected app stating why they use their respective enabled products.")
    public String getReasonForAccess() {
        return this.reasonForAccess;
    }

    public void setReasonForAccess(String reasonForAccess) {
        this.reasonForAccess = reasonForAccess;
    }

    public Application useCase(String useCase) {
        this.useCase = useCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A string representing client\u2019s broad use case as assessed by Plaid.")
    public String getUseCase() {
        return this.useCase;
    }

    public void setUseCase(String useCase) {
        this.useCase = useCase;
    }

    public Application companyLegalName(String companyLegalName) {
        this.companyLegalName = companyLegalName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A string representing the name of client\u2019s legal entity.")
    public String getCompanyLegalName() {
        return this.companyLegalName;
    }

    public void setCompanyLegalName(String companyLegalName) {
        this.companyLegalName = companyLegalName;
    }

    public Application city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A string representing the city of the client\u2019s headquarters.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Application region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A string representing the region of the client\u2019s headquarters.")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Application postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A string representing the postal code of the client\u2019s headquarters.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Application countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A string representing the country code of the client\u2019s headquarters.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application application = (Application)o;
        return Objects.equals(this.applicationId, application.applicationId) && Objects.equals(this.name, application.name) && Objects.equals(this.displayName, application.displayName) && Objects.equals(this.joinDate, application.joinDate) && Objects.equals(this.logoUrl, application.logoUrl) && Objects.equals(this.applicationUrl, application.applicationUrl) && Objects.equals(this.reasonForAccess, application.reasonForAccess) && Objects.equals(this.useCase, application.useCase) && Objects.equals(this.companyLegalName, application.companyLegalName) && Objects.equals(this.city, application.city) && Objects.equals(this.region, application.region) && Objects.equals(this.postalCode, application.postalCode) && Objects.equals(this.countryCode, application.countryCode);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.name, this.displayName, this.joinDate, this.logoUrl, this.applicationUrl, this.reasonForAccess, this.useCase, this.companyLegalName, this.city, this.region, this.postalCode, this.countryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Application {\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    joinDate: ").append(this.toIndentedString(this.joinDate)).append("\n");
        sb.append("    logoUrl: ").append(this.toIndentedString(this.logoUrl)).append("\n");
        sb.append("    applicationUrl: ").append(this.toIndentedString(this.applicationUrl)).append("\n");
        sb.append("    reasonForAccess: ").append(this.toIndentedString(this.reasonForAccess)).append("\n");
        sb.append("    useCase: ").append(this.toIndentedString(this.useCase)).append("\n");
        sb.append("    companyLegalName: ").append(this.toIndentedString(this.companyLegalName)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

