/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ApplicationGetRequest defines the schema for `/application/get`")
public class ApplicationGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_APPLICATION_ID = "application_id";
    @SerializedName(value="application_id")
    private String applicationId;

    public ApplicationGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @ApiModelProperty(required=true, value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ApplicationGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(required=true, value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ApplicationGetRequest applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @ApiModelProperty(required=true, value="This field will map to the application ID that is returned from /item/application/list, or provided to the institution in an oauth redirect.")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationGetRequest applicationGetRequest = (ApplicationGetRequest)o;
        return Objects.equals(this.clientId, applicationGetRequest.clientId) && Objects.equals(this.secret, applicationGetRequest.secret) && Objects.equals(this.applicationId, applicationGetRequest.applicationId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.applicationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

