/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AssetType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details about an asset.")
public class AssetDetail {
    public static final String SERIALIZED_NAME_ASSET_UNIQUE_IDENTIFIER = "AssetUniqueIdentifier";
    @SerializedName(value="AssetUniqueIdentifier")
    private String assetUniqueIdentifier;
    public static final String SERIALIZED_NAME_ASSET_ACCOUNT_IDENTIFIER = "AssetAccountIdentifier";
    @SerializedName(value="AssetAccountIdentifier")
    private String assetAccountIdentifier;
    public static final String SERIALIZED_NAME_ASSET_AS_OF_DATE = "AssetAsOfDate";
    @SerializedName(value="AssetAsOfDate")
    private String assetAsOfDate;
    public static final String SERIALIZED_NAME_ASSET_DESCRIPTION = "AssetDescription";
    @SerializedName(value="AssetDescription")
    private String assetDescription;
    public static final String SERIALIZED_NAME_ASSET_AVAILABLE_BALANCE_AMOUNT = "AssetAvailableBalanceAmount";
    @SerializedName(value="AssetAvailableBalanceAmount")
    private Double assetAvailableBalanceAmount;
    public static final String SERIALIZED_NAME_ASSET_CURRENT_BALANCE_AMOUNT = "AssetCurrentBalanceAmount";
    @SerializedName(value="AssetCurrentBalanceAmount")
    private Double assetCurrentBalanceAmount;
    public static final String SERIALIZED_NAME_ASSET_TYPE = "AssetType";
    @SerializedName(value="AssetType")
    private AssetType assetType;
    public static final String SERIALIZED_NAME_ASSET_TYPE_ADDITIONAL_DESCRIPTION = "AssetTypeAdditionalDescription";
    @SerializedName(value="AssetTypeAdditionalDescription")
    private String assetTypeAdditionalDescription;
    public static final String SERIALIZED_NAME_ASSET_DAYS_REQUESTED_COUNT = "AssetDaysRequestedCount";
    @SerializedName(value="AssetDaysRequestedCount")
    private Integer assetDaysRequestedCount;
    public static final String SERIALIZED_NAME_ASSET_OWNERSHIP_TYPE = "AssetOwnershipType";
    @SerializedName(value="AssetOwnershipType")
    private String assetOwnershipType;

    public AssetDetail assetUniqueIdentifier(String assetUniqueIdentifier) {
        this.assetUniqueIdentifier = assetUniqueIdentifier;
        return this;
    }

    @ApiModelProperty(required=true, value="A vendor created unique Identifier.")
    public String getAssetUniqueIdentifier() {
        return this.assetUniqueIdentifier;
    }

    public void setAssetUniqueIdentifier(String assetUniqueIdentifier) {
        this.assetUniqueIdentifier = assetUniqueIdentifier;
    }

    public AssetDetail assetAccountIdentifier(String assetAccountIdentifier) {
        this.assetAccountIdentifier = assetAccountIdentifier;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique alphanumeric string identifying an asset.")
    public String getAssetAccountIdentifier() {
        return this.assetAccountIdentifier;
    }

    public void setAssetAccountIdentifier(String assetAccountIdentifier) {
        this.assetAccountIdentifier = assetAccountIdentifier;
    }

    public AssetDetail assetAsOfDate(String assetAsOfDate) {
        this.assetAsOfDate = assetAsOfDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Account Report As of Date / Create Date. Format YYYY-MM-DD")
    public String getAssetAsOfDate() {
        return this.assetAsOfDate;
    }

    public void setAssetAsOfDate(String assetAsOfDate) {
        this.assetAsOfDate = assetAsOfDate;
    }

    public AssetDetail assetDescription(String assetDescription) {
        this.assetDescription = assetDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A text description that further defines the Asset. This could be used to describe the shares associated with the stocks, bonds or mutual funds, retirement funds or business owned that the borrower has disclosed (named) as an asset.")
    public String getAssetDescription() {
        return this.assetDescription;
    }

    public void setAssetDescription(String assetDescription) {
        this.assetDescription = assetDescription;
    }

    public AssetDetail assetAvailableBalanceAmount(Double assetAvailableBalanceAmount) {
        this.assetAvailableBalanceAmount = assetAvailableBalanceAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="Asset Account Available Balance.")
    public Double getAssetAvailableBalanceAmount() {
        return this.assetAvailableBalanceAmount;
    }

    public void setAssetAvailableBalanceAmount(Double assetAvailableBalanceAmount) {
        this.assetAvailableBalanceAmount = assetAvailableBalanceAmount;
    }

    public AssetDetail assetCurrentBalanceAmount(Double assetCurrentBalanceAmount) {
        this.assetCurrentBalanceAmount = assetCurrentBalanceAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="A vendor created unique Identifier")
    public Double getAssetCurrentBalanceAmount() {
        return this.assetCurrentBalanceAmount;
    }

    public void setAssetCurrentBalanceAmount(Double assetCurrentBalanceAmount) {
        this.assetCurrentBalanceAmount = assetCurrentBalanceAmount;
    }

    public AssetDetail assetType(AssetType assetType) {
        this.assetType = assetType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AssetType getAssetType() {
        return this.assetType;
    }

    public void setAssetType(AssetType assetType) {
        this.assetType = assetType;
    }

    public AssetDetail assetTypeAdditionalDescription(String assetTypeAdditionalDescription) {
        this.assetTypeAdditionalDescription = assetTypeAdditionalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Additional Asset Decription some examples are Investment Tax-Deferred , Loan, 401K, 403B, Checking, Money Market, Credit Card,ROTH,529,Biller,ROLLOVER,CD,Savings,Investment Taxable, IRA, Mortgage, Line Of Credit.")
    public String getAssetTypeAdditionalDescription() {
        return this.assetTypeAdditionalDescription;
    }

    public void setAssetTypeAdditionalDescription(String assetTypeAdditionalDescription) {
        this.assetTypeAdditionalDescription = assetTypeAdditionalDescription;
    }

    public AssetDetail assetDaysRequestedCount(Integer assetDaysRequestedCount) {
        this.assetDaysRequestedCount = assetDaysRequestedCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The Number of days requested made to the Financial Institution. Example When looking for 3 months of data from the FI, pass in 90 days.")
    public Integer getAssetDaysRequestedCount() {
        return this.assetDaysRequestedCount;
    }

    public void setAssetDaysRequestedCount(Integer assetDaysRequestedCount) {
        this.assetDaysRequestedCount = assetDaysRequestedCount;
    }

    public AssetDetail assetOwnershipType(String assetOwnershipType) {
        this.assetOwnershipType = assetOwnershipType;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Ownership type of the asset account.")
    public String getAssetOwnershipType() {
        return this.assetOwnershipType;
    }

    public void setAssetOwnershipType(String assetOwnershipType) {
        this.assetOwnershipType = assetOwnershipType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetDetail assetDetail = (AssetDetail)o;
        return Objects.equals(this.assetUniqueIdentifier, assetDetail.assetUniqueIdentifier) && Objects.equals(this.assetAccountIdentifier, assetDetail.assetAccountIdentifier) && Objects.equals(this.assetAsOfDate, assetDetail.assetAsOfDate) && Objects.equals(this.assetDescription, assetDetail.assetDescription) && Objects.equals(this.assetAvailableBalanceAmount, assetDetail.assetAvailableBalanceAmount) && Objects.equals(this.assetCurrentBalanceAmount, assetDetail.assetCurrentBalanceAmount) && Objects.equals((Object)this.assetType, (Object)assetDetail.assetType) && Objects.equals(this.assetTypeAdditionalDescription, assetDetail.assetTypeAdditionalDescription) && Objects.equals(this.assetDaysRequestedCount, assetDetail.assetDaysRequestedCount) && Objects.equals(this.assetOwnershipType, assetDetail.assetOwnershipType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assetUniqueIdentifier, this.assetAccountIdentifier, this.assetAsOfDate, this.assetDescription, this.assetAvailableBalanceAmount, this.assetCurrentBalanceAmount, this.assetType, this.assetTypeAdditionalDescription, this.assetDaysRequestedCount, this.assetOwnershipType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetDetail {\n");
        sb.append("    assetUniqueIdentifier: ").append(this.toIndentedString(this.assetUniqueIdentifier)).append("\n");
        sb.append("    assetAccountIdentifier: ").append(this.toIndentedString(this.assetAccountIdentifier)).append("\n");
        sb.append("    assetAsOfDate: ").append(this.toIndentedString(this.assetAsOfDate)).append("\n");
        sb.append("    assetDescription: ").append(this.toIndentedString(this.assetDescription)).append("\n");
        sb.append("    assetAvailableBalanceAmount: ").append(this.toIndentedString(this.assetAvailableBalanceAmount)).append("\n");
        sb.append("    assetCurrentBalanceAmount: ").append(this.toIndentedString(this.assetCurrentBalanceAmount)).append("\n");
        sb.append("    assetType: ").append(this.toIndentedString((Object)this.assetType)).append("\n");
        sb.append("    assetTypeAdditionalDescription: ").append(this.toIndentedString(this.assetTypeAdditionalDescription)).append("\n");
        sb.append("    assetDaysRequestedCount: ").append(this.toIndentedString(this.assetDaysRequestedCount)).append("\n");
        sb.append("    assetOwnershipType: ").append(this.toIndentedString(this.assetOwnershipType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

