/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AssetReportItem;
import com.plaid.client.model.AssetReportUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing an Asset Report")
public class AssetReport {
    public static final String SERIALIZED_NAME_ASSET_REPORT_ID = "asset_report_id";
    @SerializedName(value="asset_report_id")
    private String assetReportId;
    public static final String SERIALIZED_NAME_CLIENT_REPORT_ID = "client_report_id";
    @SerializedName(value="client_report_id")
    private String clientReportId;
    public static final String SERIALIZED_NAME_DATE_GENERATED = "date_generated";
    @SerializedName(value="date_generated")
    private OffsetDateTime dateGenerated;
    public static final String SERIALIZED_NAME_DAYS_REQUESTED = "days_requested";
    @SerializedName(value="days_requested")
    private Double daysRequested;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private AssetReportUser user;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<AssetReportItem> items = new ArrayList<AssetReportItem>();

    public AssetReport assetReportId(String assetReportId) {
        this.assetReportId = assetReportId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID identifying an Asset Report. Like all Plaid identifiers, this ID is case sensitive.")
    public String getAssetReportId() {
        return this.assetReportId;
    }

    public void setAssetReportId(String assetReportId) {
        this.assetReportId = assetReportId;
    }

    public AssetReport clientReportId(String clientReportId) {
        this.clientReportId = clientReportId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="An identifier you determine and submit for the Asset Report.")
    public String getClientReportId() {
        return this.clientReportId;
    }

    public void setClientReportId(String clientReportId) {
        this.clientReportId = clientReportId;
    }

    public AssetReport dateGenerated(OffsetDateTime dateGenerated) {
        this.dateGenerated = dateGenerated;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time when the Asset Report was created, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (e.g. \"2018-04-12T03:32:11Z\").")
    public OffsetDateTime getDateGenerated() {
        return this.dateGenerated;
    }

    public void setDateGenerated(OffsetDateTime dateGenerated) {
        this.dateGenerated = dateGenerated;
    }

    public AssetReport daysRequested(Double daysRequested) {
        this.daysRequested = daysRequested;
        return this;
    }

    @ApiModelProperty(required=true, value="The duration of transaction history you requested")
    public Double getDaysRequested() {
        return this.daysRequested;
    }

    public void setDaysRequested(Double daysRequested) {
        this.daysRequested = daysRequested;
    }

    public AssetReport user(AssetReportUser user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AssetReportUser getUser() {
        return this.user;
    }

    public void setUser(AssetReportUser user) {
        this.user = user;
    }

    public AssetReport items(List<AssetReportItem> items) {
        this.items = items;
        return this;
    }

    public AssetReport addItemsItem(AssetReportItem itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Data returned by Plaid about each of the Items included in the Asset Report.")
    public List<AssetReportItem> getItems() {
        return this.items;
    }

    public void setItems(List<AssetReportItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReport assetReport = (AssetReport)o;
        return Objects.equals(this.assetReportId, assetReport.assetReportId) && Objects.equals(this.clientReportId, assetReport.clientReportId) && Objects.equals(this.dateGenerated, assetReport.dateGenerated) && Objects.equals(this.daysRequested, assetReport.daysRequested) && Objects.equals(this.user, assetReport.user) && Objects.equals(this.items, assetReport.items);
    }

    public int hashCode() {
        return Objects.hash(this.assetReportId, this.clientReportId, this.dateGenerated, this.daysRequested, this.user, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReport {\n");
        sb.append("    assetReportId: ").append(this.toIndentedString(this.assetReportId)).append("\n");
        sb.append("    clientReportId: ").append(this.toIndentedString(this.clientReportId)).append("\n");
        sb.append("    dateGenerated: ").append(this.toIndentedString(this.dateGenerated)).append("\n");
        sb.append("    daysRequested: ").append(this.toIndentedString(this.daysRequested)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

