/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AssetReportAddOns;
import com.plaid.client.model.AssetReportUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An optional object to filter `/asset_report/create` results. If provided, must be non-`null`. The optional `user` object is required for the report to be eligible for Fannie Mae's Day 1 Certainty program.")
public class AssetReportCreateRequestOptions {
    public static final String SERIALIZED_NAME_CLIENT_REPORT_ID = "client_report_id";
    @SerializedName(value="client_report_id")
    private String clientReportId;
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private String webhook;
    public static final String SERIALIZED_NAME_INCLUDE_FAST_REPORT = "include_fast_report";
    @SerializedName(value="include_fast_report")
    private Boolean includeFastReport;
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<String> products = null;
    public static final String SERIALIZED_NAME_ADD_ONS = "add_ons";
    @SerializedName(value="add_ons")
    private List<AssetReportAddOns> addOns = null;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private AssetReportUser user;

    public AssetReportCreateRequestOptions clientReportId(String clientReportId) {
        this.clientReportId = clientReportId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Client-generated identifier, which can be used by lenders to track loan applications.")
    public String getClientReportId() {
        return this.clientReportId;
    }

    public void setClientReportId(String clientReportId) {
        this.clientReportId = clientReportId;
    }

    public AssetReportCreateRequestOptions webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL to which Plaid will send Assets webhooks, for example when the requested Asset Report is ready.")
    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public AssetReportCreateRequestOptions includeFastReport(Boolean includeFastReport) {
        this.includeFastReport = includeFastReport;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="true to return balance and identity earlier as a fast report. Defaults to false if omitted.")
    public Boolean getIncludeFastReport() {
        return this.includeFastReport;
    }

    public void setIncludeFastReport(Boolean includeFastReport) {
        this.includeFastReport = includeFastReport;
    }

    public AssetReportCreateRequestOptions products(List<String> products) {
        this.products = products;
        return this;
    }

    public AssetReportCreateRequestOptions addProductsItem(String productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<String>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Additional information that can be included in the asset report. Possible values: `\"investments\"`")
    public List<String> getProducts() {
        return this.products;
    }

    public void setProducts(List<String> products) {
        this.products = products;
    }

    public AssetReportCreateRequestOptions addOns(List<AssetReportAddOns> addOns) {
        this.addOns = addOns;
        return this;
    }

    public AssetReportCreateRequestOptions addAddOnsItem(AssetReportAddOns addOnsItem) {
        if (this.addOns == null) {
            this.addOns = new ArrayList<AssetReportAddOns>();
        }
        this.addOns.add(addOnsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use this field to request a `fast_asset` report. When Fast Assets is requested, Plaid will create two versions of the Asset Report: first, the Fast Asset Report, which will contain only current identity and balance information, and later, the Full Asset Report, which will also contain historical balance information and transaction data. A `PRODUCT_READY` webhook will be fired for each Asset Report when it is ready, and the `report_type` field will indicate whether the webhook is firing for the `full` or `fast` Asset Report. To retrieve the Fast Asset Report, call `/asset_report/get` with `fast_report` set to `true`. There is no additional charge for using Fast Assets.")
    public List<AssetReportAddOns> getAddOns() {
        return this.addOns;
    }

    public void setAddOns(List<AssetReportAddOns> addOns) {
        this.addOns = addOns;
    }

    public AssetReportCreateRequestOptions user(AssetReportUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AssetReportUser getUser() {
        return this.user;
    }

    public void setUser(AssetReportUser user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportCreateRequestOptions assetReportCreateRequestOptions = (AssetReportCreateRequestOptions)o;
        return Objects.equals(this.clientReportId, assetReportCreateRequestOptions.clientReportId) && Objects.equals(this.webhook, assetReportCreateRequestOptions.webhook) && Objects.equals(this.includeFastReport, assetReportCreateRequestOptions.includeFastReport) && Objects.equals(this.products, assetReportCreateRequestOptions.products) && Objects.equals(this.addOns, assetReportCreateRequestOptions.addOns) && Objects.equals(this.user, assetReportCreateRequestOptions.user);
    }

    public int hashCode() {
        return Objects.hash(this.clientReportId, this.webhook, this.includeFastReport, this.products, this.addOns, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportCreateRequestOptions {\n");
        sb.append("    clientReportId: ").append(this.toIndentedString(this.clientReportId)).append("\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("    includeFastReport: ").append(this.toIndentedString(this.includeFastReport)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    addOns: ").append(this.toIndentedString(this.addOns)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

