/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AssetReportFilterRequest defines the request schema for `/asset_report/filter`")
public class AssetReportFilterRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ASSET_REPORT_TOKEN = "asset_report_token";
    @SerializedName(value="asset_report_token")
    private String assetReportToken;
    public static final String SERIALIZED_NAME_ACCOUNT_IDS_TO_EXCLUDE = "account_ids_to_exclude";
    @SerializedName(value="account_ids_to_exclude")
    private List<String> accountIdsToExclude = new ArrayList<String>();

    public AssetReportFilterRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AssetReportFilterRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public AssetReportFilterRequest assetReportToken(String assetReportToken) {
        this.assetReportToken = assetReportToken;
        return this;
    }

    @ApiModelProperty(required=true, value="A token that can be provided to endpoints such as `/asset_report/get` or `/asset_report/pdf/get` to fetch or update an Asset Report.")
    public String getAssetReportToken() {
        return this.assetReportToken;
    }

    public void setAssetReportToken(String assetReportToken) {
        this.assetReportToken = assetReportToken;
    }

    public AssetReportFilterRequest accountIdsToExclude(List<String> accountIdsToExclude) {
        this.accountIdsToExclude = accountIdsToExclude;
        return this;
    }

    public AssetReportFilterRequest addAccountIdsToExcludeItem(String accountIdsToExcludeItem) {
        this.accountIdsToExclude.add(accountIdsToExcludeItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The accounts to exclude from the Asset Report, identified by `account_id`.")
    public List<String> getAccountIdsToExclude() {
        return this.accountIdsToExclude;
    }

    public void setAccountIdsToExclude(List<String> accountIdsToExclude) {
        this.accountIdsToExclude = accountIdsToExclude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportFilterRequest assetReportFilterRequest = (AssetReportFilterRequest)o;
        return Objects.equals(this.clientId, assetReportFilterRequest.clientId) && Objects.equals(this.secret, assetReportFilterRequest.secret) && Objects.equals(this.assetReportToken, assetReportFilterRequest.assetReportToken) && Objects.equals(this.accountIdsToExclude, assetReportFilterRequest.accountIdsToExclude);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.assetReportToken, this.accountIdsToExclude);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportFilterRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    assetReportToken: ").append(this.toIndentedString(this.assetReportToken)).append("\n");
        sb.append("    accountIdsToExclude: ").append(this.toIndentedString(this.accountIdsToExclude)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

