/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AssetReportGetRequestOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AssetReportGetRequest defines the request schema for `/asset_report/get`")
public class AssetReportGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ASSET_REPORT_TOKEN = "asset_report_token";
    @SerializedName(value="asset_report_token")
    private String assetReportToken;
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_INCLUDE_INSIGHTS = "include_insights";
    @SerializedName(value="include_insights")
    private Boolean includeInsights = false;
    public static final String SERIALIZED_NAME_FAST_REPORT = "fast_report";
    @SerializedName(value="fast_report")
    private Boolean fastReport = false;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private AssetReportGetRequestOptions options;

    public AssetReportGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AssetReportGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public AssetReportGetRequest assetReportToken(String assetReportToken) {
        this.assetReportToken = assetReportToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A token that can be provided to endpoints such as `/asset_report/get` or `/asset_report/pdf/get` to fetch or update an Asset Report.")
    public String getAssetReportToken() {
        return this.assetReportToken;
    }

    public void setAssetReportToken(String assetReportToken) {
        this.assetReportToken = assetReportToken;
    }

    public AssetReportGetRequest userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user token associated with the User for which to create an asset report for. The latest asset report associated with the User will be returned")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public AssetReportGetRequest includeInsights(Boolean includeInsights) {
        this.includeInsights = includeInsights;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`true` if you would like to retrieve the Asset Report with Insights, `false` otherwise. This field defaults to `false` if omitted.")
    public Boolean getIncludeInsights() {
        return this.includeInsights;
    }

    public void setIncludeInsights(Boolean includeInsights) {
        this.includeInsights = includeInsights;
    }

    public AssetReportGetRequest fastReport(Boolean fastReport) {
        this.fastReport = fastReport;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`true` to fetch \"fast\" version of asset report. Defaults to false if omitted. Can only be used if `/asset_report/create` was called with `options.add_ons` set to `[\"fast_assets\"]`.")
    public Boolean getFastReport() {
        return this.fastReport;
    }

    public void setFastReport(Boolean fastReport) {
        this.fastReport = fastReport;
    }

    public AssetReportGetRequest options(AssetReportGetRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AssetReportGetRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(AssetReportGetRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportGetRequest assetReportGetRequest = (AssetReportGetRequest)o;
        return Objects.equals(this.clientId, assetReportGetRequest.clientId) && Objects.equals(this.secret, assetReportGetRequest.secret) && Objects.equals(this.assetReportToken, assetReportGetRequest.assetReportToken) && Objects.equals(this.userToken, assetReportGetRequest.userToken) && Objects.equals(this.includeInsights, assetReportGetRequest.includeInsights) && Objects.equals(this.fastReport, assetReportGetRequest.fastReport) && Objects.equals(this.options, assetReportGetRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.assetReportToken, this.userToken, this.includeInsights, this.fastReport, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    assetReportToken: ").append(this.toIndentedString(this.assetReportToken)).append("\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    includeInsights: ").append(this.toIndentedString(this.includeInsights)).append("\n");
        sb.append("    fastReport: ").append(this.toIndentedString(this.fastReport)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

