/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AssetReport;
import com.plaid.client.model.Warning;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="AssetReportGetResponse defines the response schema for `/asset_report/get`")
public class AssetReportGetResponse {
    public static final String SERIALIZED_NAME_REPORT = "report";
    @SerializedName(value="report")
    private AssetReport report;
    public static final String SERIALIZED_NAME_WARNINGS = "warnings";
    @SerializedName(value="warnings")
    private List<Warning> warnings = new ArrayList<Warning>();
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public AssetReportGetResponse report(AssetReport report) {
        this.report = report;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AssetReport getReport() {
        return this.report;
    }

    public void setReport(AssetReport report) {
        this.report = report;
    }

    public AssetReportGetResponse warnings(List<Warning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public AssetReportGetResponse addWarningsItem(Warning warningsItem) {
        this.warnings.add(warningsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="If the Asset Report generation was successful but identity information cannot be returned, this array will contain information about the errors causing identity information to be missing")
    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<Warning> warnings) {
        this.warnings = warnings;
    }

    public AssetReportGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportGetResponse assetReportGetResponse = (AssetReportGetResponse)o;
        return Objects.equals(this.report, assetReportGetResponse.report) && Objects.equals(this.warnings, assetReportGetResponse.warnings) && Objects.equals(this.requestId, assetReportGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.report, this.warnings, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportGetResponse {\n");
        sb.append("    report: ").append(this.toIndentedString(this.report)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

