/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A securities holding at an institution.")
public class AssetReportInvestmentHolding {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_SECURITY_ID = "security_id";
    @SerializedName(value="security_id")
    private String securityId;
    public static final String SERIALIZED_NAME_TICKER_SYMBOL = "ticker_symbol";
    @SerializedName(value="ticker_symbol")
    private String tickerSymbol;
    public static final String SERIALIZED_NAME_INSTITUTION_PRICE = "institution_price";
    @SerializedName(value="institution_price")
    private Double institutionPrice;
    public static final String SERIALIZED_NAME_INSTITUTION_PRICE_AS_OF = "institution_price_as_of";
    @SerializedName(value="institution_price_as_of")
    private LocalDate institutionPriceAsOf;
    public static final String SERIALIZED_NAME_INSTITUTION_VALUE = "institution_value";
    @SerializedName(value="institution_value")
    private Double institutionValue;
    public static final String SERIALIZED_NAME_COST_BASIS = "cost_basis";
    @SerializedName(value="cost_basis")
    private Double costBasis;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Double quantity;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;

    public AssetReportInvestmentHolding accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `account_id` associated with the holding.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AssetReportInvestmentHolding securityId(String securityId) {
        this.securityId = securityId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `security_id` associated with the holding. Security data is not specific to a user's account; any user who held the same security at the same financial institution at the same time would have identical security data. The `security_id` for the same security will typically be the same across different institutions, but this is not guaranteed. The `security_id` does not typically change, but may change if inherent details of the security change due to a corporate action, for example, in the event of a ticker symbol change or CUSIP change.")
    public String getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public AssetReportInvestmentHolding tickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The holding's trading symbol for publicly traded holdings, and otherwise a short identifier if available.")
    public String getTickerSymbol() {
        return this.tickerSymbol;
    }

    public void setTickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
    }

    public AssetReportInvestmentHolding institutionPrice(Double institutionPrice) {
        this.institutionPrice = institutionPrice;
        return this;
    }

    @ApiModelProperty(required=true, value="The last price given by the institution for this security.")
    public Double getInstitutionPrice() {
        return this.institutionPrice;
    }

    public void setInstitutionPrice(Double institutionPrice) {
        this.institutionPrice = institutionPrice;
    }

    public AssetReportInvestmentHolding institutionPriceAsOf(LocalDate institutionPriceAsOf) {
        this.institutionPriceAsOf = institutionPriceAsOf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date at which `institution_price` was current.")
    public LocalDate getInstitutionPriceAsOf() {
        return this.institutionPriceAsOf;
    }

    public void setInstitutionPriceAsOf(LocalDate institutionPriceAsOf) {
        this.institutionPriceAsOf = institutionPriceAsOf;
    }

    public AssetReportInvestmentHolding institutionValue(Double institutionValue) {
        this.institutionValue = institutionValue;
        return this;
    }

    @ApiModelProperty(required=true, value="The value of the holding, as reported by the institution.")
    public Double getInstitutionValue() {
        return this.institutionValue;
    }

    public void setInstitutionValue(Double institutionValue) {
        this.institutionValue = institutionValue;
    }

    public AssetReportInvestmentHolding costBasis(Double costBasis) {
        this.costBasis = costBasis;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The original total value of the holding. This field is calculated by Plaid as the sum of the purchase price of all of the shares in the holding.")
    public Double getCostBasis() {
        return this.costBasis;
    }

    public void setCostBasis(Double costBasis) {
        this.costBasis = costBasis;
    }

    public AssetReportInvestmentHolding quantity(Double quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The total quantity of the asset held, as reported by the financial institution. If the security is an option, `quantity` will reflect the total number of options (typically the number of contracts multiplied by 100), not the number of contracts.")
    public Double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public AssetReportInvestmentHolding isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the holding. Always `null` if `unofficial_currency_code` is non-`null`.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public AssetReportInvestmentHolding unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the holding. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s. ")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportInvestmentHolding assetReportInvestmentHolding = (AssetReportInvestmentHolding)o;
        return Objects.equals(this.accountId, assetReportInvestmentHolding.accountId) && Objects.equals(this.securityId, assetReportInvestmentHolding.securityId) && Objects.equals(this.tickerSymbol, assetReportInvestmentHolding.tickerSymbol) && Objects.equals(this.institutionPrice, assetReportInvestmentHolding.institutionPrice) && Objects.equals(this.institutionPriceAsOf, assetReportInvestmentHolding.institutionPriceAsOf) && Objects.equals(this.institutionValue, assetReportInvestmentHolding.institutionValue) && Objects.equals(this.costBasis, assetReportInvestmentHolding.costBasis) && Objects.equals(this.quantity, assetReportInvestmentHolding.quantity) && Objects.equals(this.isoCurrencyCode, assetReportInvestmentHolding.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, assetReportInvestmentHolding.unofficialCurrencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.securityId, this.tickerSymbol, this.institutionPrice, this.institutionPriceAsOf, this.institutionValue, this.costBasis, this.quantity, this.isoCurrencyCode, this.unofficialCurrencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportInvestmentHolding {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    securityId: ").append(this.toIndentedString(this.securityId)).append("\n");
        sb.append("    tickerSymbol: ").append(this.toIndentedString(this.tickerSymbol)).append("\n");
        sb.append("    institutionPrice: ").append(this.toIndentedString(this.institutionPrice)).append("\n");
        sb.append("    institutionPriceAsOf: ").append(this.toIndentedString(this.institutionPriceAsOf)).append("\n");
        sb.append("    institutionValue: ").append(this.toIndentedString(this.institutionValue)).append("\n");
        sb.append("    costBasis: ").append(this.toIndentedString(this.costBasis)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

