/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Investment security associated with the account.")
public class AssetReportInvestmentSecurity {
    public static final String SERIALIZED_NAME_SECURITY_ID = "security_id";
    @SerializedName(value="security_id")
    private String securityId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TICKER_SYMBOL = "ticker_symbol";
    @SerializedName(value="ticker_symbol")
    private String tickerSymbol;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public AssetReportInvestmentSecurity securityId(String securityId) {
        this.securityId = securityId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique, Plaid-specific identifier for the security, used to associate securities with holdings. Like all Plaid identifiers, the `security_id` is case sensitive. The `security_id` may change if inherent details of the security change due to a corporate action, for example, in the event of a ticker symbol change or CUSIP change.")
    public String getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public AssetReportInvestmentSecurity name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A descriptive name for the security, suitable for display.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AssetReportInvestmentSecurity tickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The security\u2019s trading symbol for publicly traded securities, and otherwise a short identifier if available.")
    public String getTickerSymbol() {
        return this.tickerSymbol;
    }

    public void setTickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
    }

    public AssetReportInvestmentSecurity type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The security type of the holding. Valid security types are:  `cash`: Cash, currency, and money market funds  `cryptocurrency`: Digital or virtual currencies  `derivative`: Options, warrants, and other derivative instruments  `equity`: Domestic and foreign equities  `etf`: Multi-asset exchange-traded investment funds  `fixed income`: Bonds and certificates of deposit (CDs)  `loan`: Loans and loan receivables  `mutual fund`: Open- and closed-end vehicles pooling funds of multiple investors  `other`: Unknown or other investment types")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportInvestmentSecurity assetReportInvestmentSecurity = (AssetReportInvestmentSecurity)o;
        return Objects.equals(this.securityId, assetReportInvestmentSecurity.securityId) && Objects.equals(this.name, assetReportInvestmentSecurity.name) && Objects.equals(this.tickerSymbol, assetReportInvestmentSecurity.tickerSymbol) && Objects.equals(this.type, assetReportInvestmentSecurity.type);
    }

    public int hashCode() {
        return Objects.hash(this.securityId, this.name, this.tickerSymbol, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportInvestmentSecurity {\n");
        sb.append("    securityId: ").append(this.toIndentedString(this.securityId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tickerSymbol: ").append(this.toIndentedString(this.tickerSymbol)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

