/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.InvestmentTransactionSubtype;
import com.plaid.client.model.InvestmentTransactionType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A transaction within an investment account.")
public class AssetReportInvestments {
    public static final String SERIALIZED_NAME_INVESTMENT_TRANSACTION_ID = "investment_transaction_id";
    @SerializedName(value="investment_transaction_id")
    private String investmentTransactionId;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_SECURITY_ID = "security_id";
    @SerializedName(value="security_id")
    private String securityId;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Double quantity;
    public static final String SERIALIZED_NAME_VESTED_QUANTITY = "vested_quantity";
    @SerializedName(value="vested_quantity")
    private Double vestedQuantity;
    public static final String SERIALIZED_NAME_VESTED_VALUE = "vested_value";
    @SerializedName(value="vested_value")
    private Double vestedValue;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    private Double price;
    public static final String SERIALIZED_NAME_FEES = "fees";
    @SerializedName(value="fees")
    private Double fees;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private InvestmentTransactionType type;
    public static final String SERIALIZED_NAME_SUBTYPE = "subtype";
    @SerializedName(value="subtype")
    private InvestmentTransactionSubtype subtype;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;

    public AssetReportInvestments investmentTransactionId(String investmentTransactionId) {
        this.investmentTransactionId = investmentTransactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the Investment transaction, unique across all Plaid transactions. Like all Plaid identifiers, the `investment_transaction_id` is case sensitive.")
    public String getInvestmentTransactionId() {
        return this.investmentTransactionId;
    }

    public void setInvestmentTransactionId(String investmentTransactionId) {
        this.investmentTransactionId = investmentTransactionId;
    }

    public AssetReportInvestments accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `account_id` of the account against which this transaction posted.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AssetReportInvestments securityId(String securityId) {
        this.securityId = securityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The `security_id` to which this transaction is related.")
    public String getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public AssetReportInvestments date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(required=true, value="The [ISO 8601](https://wikipedia.org/wiki/ISO_8601) posting date for the transaction.")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public AssetReportInvestments name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The institution\u2019s description of the transaction.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AssetReportInvestments quantity(Double quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of units of the security involved in this transaction. Positive for buy transactions; negative for sell transactions.")
    public Double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public AssetReportInvestments vestedQuantity(Double vestedQuantity) {
        this.vestedQuantity = vestedQuantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The total quantity of vested assets held, as reported by the financial institution. Vested assets are only associated with [equities](https://plaid.com/docs/api/products/investments/#investments-holdings-get-response-securities-type).")
    public Double getVestedQuantity() {
        return this.vestedQuantity;
    }

    public void setVestedQuantity(Double vestedQuantity) {
        this.vestedQuantity = vestedQuantity;
    }

    public AssetReportInvestments vestedValue(Double vestedValue) {
        this.vestedValue = vestedValue;
        return this;
    }

    @ApiModelProperty(required=true, value="The value of the vested holdings as reported by the institution.")
    public Double getVestedValue() {
        return this.vestedValue;
    }

    public void setVestedValue(Double vestedValue) {
        this.vestedValue = vestedValue;
    }

    public AssetReportInvestments amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The complete value of the transaction. Positive values when cash is debited, e.g. purchases of stock; negative values when cash is credited, e.g. sales of stock. Treatment remains the same for cash-only movements unassociated with securities.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public AssetReportInvestments price(Double price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(required=true, value="The price of the security at which this transaction occurred.")
    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public AssetReportInvestments fees(Double fees) {
        this.fees = fees;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The combined value of all fees applied to this transaction")
    public Double getFees() {
        return this.fees;
    }

    public void setFees(Double fees) {
        this.fees = fees;
    }

    public AssetReportInvestments type(InvestmentTransactionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public InvestmentTransactionType getType() {
        return this.type;
    }

    public void setType(InvestmentTransactionType type) {
        this.type = type;
    }

    public AssetReportInvestments subtype(InvestmentTransactionSubtype subtype) {
        this.subtype = subtype;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public InvestmentTransactionSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(InvestmentTransactionSubtype subtype) {
        this.subtype = subtype;
    }

    public AssetReportInvestments isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the transaction. Always `null` if `unofficial_currency_code` is non-`null`.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public AssetReportInvestments unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the holding. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportInvestments assetReportInvestments = (AssetReportInvestments)o;
        return Objects.equals(this.investmentTransactionId, assetReportInvestments.investmentTransactionId) && Objects.equals(this.accountId, assetReportInvestments.accountId) && Objects.equals(this.securityId, assetReportInvestments.securityId) && Objects.equals(this.date, assetReportInvestments.date) && Objects.equals(this.name, assetReportInvestments.name) && Objects.equals(this.quantity, assetReportInvestments.quantity) && Objects.equals(this.vestedQuantity, assetReportInvestments.vestedQuantity) && Objects.equals(this.vestedValue, assetReportInvestments.vestedValue) && Objects.equals(this.amount, assetReportInvestments.amount) && Objects.equals(this.price, assetReportInvestments.price) && Objects.equals(this.fees, assetReportInvestments.fees) && Objects.equals((Object)this.type, (Object)assetReportInvestments.type) && Objects.equals((Object)this.subtype, (Object)assetReportInvestments.subtype) && Objects.equals(this.isoCurrencyCode, assetReportInvestments.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, assetReportInvestments.unofficialCurrencyCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.investmentTransactionId, this.accountId, this.securityId, this.date, this.name, this.quantity, this.vestedQuantity, this.vestedValue, this.amount, this.price, this.fees, this.type, this.subtype, this.isoCurrencyCode, this.unofficialCurrencyCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportInvestments {\n");
        sb.append("    investmentTransactionId: ").append(this.toIndentedString(this.investmentTransactionId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    securityId: ").append(this.toIndentedString(this.securityId)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    vestedQuantity: ").append(this.toIndentedString(this.vestedQuantity)).append("\n");
        sb.append("    vestedValue: ").append(this.toIndentedString(this.vestedValue)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString((Object)this.subtype)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

