/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountAssets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A representation of an Item within an Asset Report.")
public class AssetReportItem {
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_INSTITUTION_NAME = "institution_name";
    @SerializedName(value="institution_name")
    private String institutionName;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_DATE_LAST_UPDATED = "date_last_updated";
    @SerializedName(value="date_last_updated")
    private OffsetDateTime dateLastUpdated;
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<AccountAssets> accounts = new ArrayList<AccountAssets>();

    public AssetReportItem itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public AssetReportItem institutionName(String institutionName) {
        this.institutionName = institutionName;
        return this;
    }

    @ApiModelProperty(required=true, value="The full financial institution name associated with the Item.")
    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public AssetReportItem institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of the financial institution associated with the Item.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public AssetReportItem dateLastUpdated(OffsetDateTime dateLastUpdated) {
        this.dateLastUpdated = dateLastUpdated;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time when this Item\u2019s data was last retrieved from the financial institution, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public OffsetDateTime getDateLastUpdated() {
        return this.dateLastUpdated;
    }

    public void setDateLastUpdated(OffsetDateTime dateLastUpdated) {
        this.dateLastUpdated = dateLastUpdated;
    }

    public AssetReportItem accounts(List<AccountAssets> accounts) {
        this.accounts = accounts;
        return this;
    }

    public AssetReportItem addAccountsItem(AccountAssets accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Data about each of the accounts open on the Item.")
    public List<AccountAssets> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountAssets> accounts) {
        this.accounts = accounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportItem assetReportItem = (AssetReportItem)o;
        return Objects.equals(this.itemId, assetReportItem.itemId) && Objects.equals(this.institutionName, assetReportItem.institutionName) && Objects.equals(this.institutionId, assetReportItem.institutionId) && Objects.equals(this.dateLastUpdated, assetReportItem.dateLastUpdated) && Objects.equals(this.accounts, assetReportItem.accounts);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.institutionName, this.institutionId, this.dateLastUpdated, this.accounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportItem {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    institutionName: ").append(this.toIndentedString(this.institutionName)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    dateLastUpdated: ").append(this.toIndentedString(this.dateLastUpdated)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

