/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AssetReportRefreshRequestOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AssetReportRefreshRequest defines the request schema for `/asset_report/refresh`")
public class AssetReportRefreshRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ASSET_REPORT_TOKEN = "asset_report_token";
    @SerializedName(value="asset_report_token")
    private String assetReportToken;
    public static final String SERIALIZED_NAME_DAYS_REQUESTED = "days_requested";
    @SerializedName(value="days_requested")
    private Integer daysRequested;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private AssetReportRefreshRequestOptions options;

    public AssetReportRefreshRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AssetReportRefreshRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public AssetReportRefreshRequest assetReportToken(String assetReportToken) {
        this.assetReportToken = assetReportToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The `asset_report_token` returned by the original call to `/asset_report/create`")
    public String getAssetReportToken() {
        return this.assetReportToken;
    }

    public void setAssetReportToken(String assetReportToken) {
        this.assetReportToken = assetReportToken;
    }

    public AssetReportRefreshRequest daysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of days of history to include in the Asset Report. Must be an integer. If not specified, the value from the original call to `/asset_report/create` will be used.")
    public Integer getDaysRequested() {
        return this.daysRequested;
    }

    public void setDaysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
    }

    public AssetReportRefreshRequest options(AssetReportRefreshRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AssetReportRefreshRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(AssetReportRefreshRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportRefreshRequest assetReportRefreshRequest = (AssetReportRefreshRequest)o;
        return Objects.equals(this.clientId, assetReportRefreshRequest.clientId) && Objects.equals(this.secret, assetReportRefreshRequest.secret) && Objects.equals(this.assetReportToken, assetReportRefreshRequest.assetReportToken) && Objects.equals(this.daysRequested, assetReportRefreshRequest.daysRequested) && Objects.equals(this.options, assetReportRefreshRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.assetReportToken, this.daysRequested, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportRefreshRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    assetReportToken: ").append(this.toIndentedString(this.assetReportToken)).append("\n");
        sb.append("    daysRequested: ").append(this.toIndentedString(this.daysRequested)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

