/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AssetReportTransactionType;
import com.plaid.client.model.CreditCategory;
import com.plaid.client.model.Location;
import com.plaid.client.model.PaymentMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A transaction on the asset report")
public class AssetReportTransaction {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_ORIGINAL_DESCRIPTION = "original_description";
    @SerializedName(value="original_description")
    private String originalDescription;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private List<String> category = null;
    public static final String SERIALIZED_NAME_CATEGORY_ID = "category_id";
    @SerializedName(value="category_id")
    private String categoryId;
    public static final String SERIALIZED_NAME_CREDIT_CATEGORY = "credit_category";
    @SerializedName(value="credit_category")
    private CreditCategory creditCategory;
    public static final String SERIALIZED_NAME_CHECK_NUMBER = "check_number";
    @SerializedName(value="check_number")
    private String checkNumber;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;
    public static final String SERIALIZED_NAME_DATE_TRANSACTED = "date_transacted";
    @SerializedName(value="date_transacted")
    private String dateTransacted;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private Location location;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchant_name";
    @SerializedName(value="merchant_name")
    private String merchantName;
    public static final String SERIALIZED_NAME_PAYMENT_META = "payment_meta";
    @SerializedName(value="payment_meta")
    private PaymentMeta paymentMeta;
    public static final String SERIALIZED_NAME_PENDING = "pending";
    @SerializedName(value="pending")
    private Boolean pending;
    public static final String SERIALIZED_NAME_PENDING_TRANSACTION_ID = "pending_transaction_id";
    @SerializedName(value="pending_transaction_id")
    private String pendingTransactionId;
    public static final String SERIALIZED_NAME_ACCOUNT_OWNER = "account_owner";
    @SerializedName(value="account_owner")
    private String accountOwner;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transaction_id";
    @SerializedName(value="transaction_id")
    private String transactionId;
    public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transaction_type";
    @SerializedName(value="transaction_type")
    private AssetReportTransactionType transactionType;
    public static final String SERIALIZED_NAME_INCOME_SOURCE_ID = "income_source_id";
    @SerializedName(value="income_source_id")
    private String incomeSourceId;

    public AssetReportTransaction accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the account in which this transaction occurred.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AssetReportTransaction amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The settled value of the transaction, denominated in the transaction's currency, as stated in `iso_currency_code` or `unofficial_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, debit card purchases are positive; credit card payments, direct deposits, and refunds are negative.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public AssetReportTransaction isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the transaction. Always `null` if `unofficial_currency_code` is non-null.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public AssetReportTransaction unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the transaction. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `unofficial_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public AssetReportTransaction originalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The string returned by the financial institution to describe the transaction.")
    public String getOriginalDescription() {
        return this.originalDescription;
    }

    public void setOriginalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
    }

    public AssetReportTransaction category(List<String> category) {
        this.category = category;
        return this;
    }

    public AssetReportTransaction addCategoryItem(String categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<String>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A hierarchical array of the categories to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).  This field will only appear in an Asset Report with Insights.")
    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }

    public AssetReportTransaction categoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the category to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).  This field will only appear in an Asset Report with Insights.")
    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public AssetReportTransaction creditCategory(CreditCategory creditCategory) {
        this.creditCategory = creditCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditCategory getCreditCategory() {
        return this.creditCategory;
    }

    public void setCreditCategory(CreditCategory creditCategory) {
        this.creditCategory = creditCategory;
    }

    public AssetReportTransaction checkNumber(String checkNumber) {
        this.checkNumber = checkNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The check number of the transaction. This field is only populated for check transactions.")
    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public AssetReportTransaction date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(required=true, value="For pending transactions, the date that the transaction occurred; for posted transactions, the date that the transaction posted. Both dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DD` ).")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public AssetReportTransaction dateTransacted(String dateTransacted) {
        this.dateTransacted = dateTransacted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date on which the transaction took place, in IS0 8601 format.")
    public String getDateTransacted() {
        return this.dateTransacted;
    }

    public void setDateTransacted(String dateTransacted) {
        this.dateTransacted = dateTransacted;
    }

    public AssetReportTransaction location(Location location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public AssetReportTransaction name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The merchant name or transaction description.  This field will only appear in an Asset Report with Insights.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AssetReportTransaction merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The merchant name, as enriched by Plaid from the `name` field. This is typically a more human-readable version of the merchant counterparty in the transaction. For some bank transactions (such as checks or account transfers) where there is no meaningful merchant name, this value will be `null`.")
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public AssetReportTransaction paymentMeta(PaymentMeta paymentMeta) {
        this.paymentMeta = paymentMeta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentMeta getPaymentMeta() {
        return this.paymentMeta;
    }

    public void setPaymentMeta(PaymentMeta paymentMeta) {
        this.paymentMeta = paymentMeta;
    }

    public AssetReportTransaction pending(Boolean pending) {
        this.pending = pending;
        return this;
    }

    @ApiModelProperty(required=true, value="When `true`, identifies the transaction as pending or unsettled. Pending transaction details (name, type, amount, category ID) may change before they are settled.")
    public Boolean getPending() {
        return this.pending;
    }

    public void setPending(Boolean pending) {
        this.pending = pending;
    }

    public AssetReportTransaction pendingTransactionId(String pendingTransactionId) {
        this.pendingTransactionId = pendingTransactionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of a posted transaction's associated pending transaction, where applicable.")
    public String getPendingTransactionId() {
        return this.pendingTransactionId;
    }

    public void setPendingTransactionId(String pendingTransactionId) {
        this.pendingTransactionId = pendingTransactionId;
    }

    public AssetReportTransaction accountOwner(String accountOwner) {
        this.accountOwner = accountOwner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the account owner. This field is not typically populated and only relevant when dealing with sub-accounts.")
    public String getAccountOwner() {
        return this.accountOwner;
    }

    public void setAccountOwner(String accountOwner) {
        this.accountOwner = accountOwner;
    }

    public AssetReportTransaction transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID of the transaction. Like all Plaid identifiers, the `transaction_id` is case sensitive.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public AssetReportTransaction transactionType(AssetReportTransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AssetReportTransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(AssetReportTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public AssetReportTransaction incomeSourceId(String incomeSourceId) {
        this.incomeSourceId = incomeSourceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for an income source.")
    public String getIncomeSourceId() {
        return this.incomeSourceId;
    }

    public void setIncomeSourceId(String incomeSourceId) {
        this.incomeSourceId = incomeSourceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportTransaction assetReportTransaction = (AssetReportTransaction)o;
        return Objects.equals(this.accountId, assetReportTransaction.accountId) && Objects.equals(this.amount, assetReportTransaction.amount) && Objects.equals(this.isoCurrencyCode, assetReportTransaction.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, assetReportTransaction.unofficialCurrencyCode) && Objects.equals(this.originalDescription, assetReportTransaction.originalDescription) && Objects.equals(this.category, assetReportTransaction.category) && Objects.equals(this.categoryId, assetReportTransaction.categoryId) && Objects.equals(this.creditCategory, assetReportTransaction.creditCategory) && Objects.equals(this.checkNumber, assetReportTransaction.checkNumber) && Objects.equals(this.date, assetReportTransaction.date) && Objects.equals(this.dateTransacted, assetReportTransaction.dateTransacted) && Objects.equals(this.location, assetReportTransaction.location) && Objects.equals(this.name, assetReportTransaction.name) && Objects.equals(this.merchantName, assetReportTransaction.merchantName) && Objects.equals(this.paymentMeta, assetReportTransaction.paymentMeta) && Objects.equals(this.pending, assetReportTransaction.pending) && Objects.equals(this.pendingTransactionId, assetReportTransaction.pendingTransactionId) && Objects.equals(this.accountOwner, assetReportTransaction.accountOwner) && Objects.equals(this.transactionId, assetReportTransaction.transactionId) && Objects.equals((Object)this.transactionType, (Object)assetReportTransaction.transactionType) && Objects.equals(this.incomeSourceId, assetReportTransaction.incomeSourceId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.amount, this.isoCurrencyCode, this.unofficialCurrencyCode, this.originalDescription, this.category, this.categoryId, this.creditCategory, this.checkNumber, this.date, this.dateTransacted, this.location, this.name, this.merchantName, this.paymentMeta, this.pending, this.pendingTransactionId, this.accountOwner, this.transactionId, this.transactionType, this.incomeSourceId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportTransaction {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    originalDescription: ").append(this.toIndentedString(this.originalDescription)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    creditCategory: ").append(this.toIndentedString(this.creditCategory)).append("\n");
        sb.append("    checkNumber: ").append(this.toIndentedString(this.checkNumber)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    dateTransacted: ").append(this.toIndentedString(this.dateTransacted)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    paymentMeta: ").append(this.toIndentedString(this.paymentMeta)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("    pendingTransactionId: ").append(this.toIndentedString(this.pendingTransactionId)).append("\n");
        sb.append("    accountOwner: ").append(this.toIndentedString(this.accountOwner)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString((Object)this.transactionType)).append("\n");
        sb.append("    incomeSourceId: ").append(this.toIndentedString(this.incomeSourceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

