/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The user object allows you to provide additional information about the user to be appended to the Asset Report. All fields are optional. The `first_name`, `last_name`, and `ssn` fields are required if you would like the Report to be eligible for Fannie Mae\u2019s Day 1 Certainty\u2122 program.")
public class AssetReportUser {
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_FIRST_NAME = "first_name";
    @SerializedName(value="first_name")
    private String firstName;
    public static final String SERIALIZED_NAME_MIDDLE_NAME = "middle_name";
    @SerializedName(value="middle_name")
    private String middleName;
    public static final String SERIALIZED_NAME_LAST_NAME = "last_name";
    @SerializedName(value="last_name")
    private String lastName;
    public static final String SERIALIZED_NAME_SSN = "ssn";
    @SerializedName(value="ssn")
    private String ssn;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;

    public AssetReportUser clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An identifier you determine and submit for the user.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public AssetReportUser firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's first name. Required for the Fannie Mae Day 1 Certainty\u2122 program.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public AssetReportUser middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's middle name")
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public AssetReportUser lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's last name.  Required for the Fannie Mae Day 1 Certainty\u2122 program.")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public AssetReportUser ssn(String ssn) {
        this.ssn = ssn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's Social Security Number. Required for the Fannie Mae Day 1 Certainty\u2122 program.  Format: \"ddd-dd-dddd\"")
    public String getSsn() {
        return this.ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public AssetReportUser phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's phone number, in E.164 format: +{countrycode}{number}. For example: \"+14151234567\". Phone numbers provided in other formats will be parsed on a best-effort basis.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public AssetReportUser email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's email address.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReportUser assetReportUser = (AssetReportUser)o;
        return Objects.equals(this.clientUserId, assetReportUser.clientUserId) && Objects.equals(this.firstName, assetReportUser.firstName) && Objects.equals(this.middleName, assetReportUser.middleName) && Objects.equals(this.lastName, assetReportUser.lastName) && Objects.equals(this.ssn, assetReportUser.ssn) && Objects.equals(this.phoneNumber, assetReportUser.phoneNumber) && Objects.equals(this.email, assetReportUser.email);
    }

    public int hashCode() {
        return Objects.hash(this.clientUserId, this.firstName, this.middleName, this.lastName, this.ssn, this.phoneNumber, this.email);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReportUser {\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    middleName: ").append(this.toIndentedString(this.middleName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    ssn: ").append(this.toIndentedString(this.ssn)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

