/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when Asset Report generation has failed. The resulting `error` will have an `error_type` of `ASSET_REPORT_ERROR`.")
public class AssetsErrorWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_ASSET_REPORT_ID = "asset_report_id";
    @SerializedName(value="asset_report_id")
    private String assetReportId;
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public AssetsErrorWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`ASSETS`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public AssetsErrorWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`ERROR`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public AssetsErrorWebhook error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public AssetsErrorWebhook assetReportId(String assetReportId) {
        this.assetReportId = assetReportId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID associated with the Asset Report.")
    public String getAssetReportId() {
        return this.assetReportId;
    }

    public void setAssetReportId(String assetReportId) {
        this.assetReportId = assetReportId;
    }

    public AssetsErrorWebhook userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `user_id` corresponding to the User ID the webhook has fired for.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AssetsErrorWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetsErrorWebhook assetsErrorWebhook = (AssetsErrorWebhook)o;
        return Objects.equals(this.webhookType, assetsErrorWebhook.webhookType) && Objects.equals(this.webhookCode, assetsErrorWebhook.webhookCode) && Objects.equals(this.error, assetsErrorWebhook.error) && Objects.equals(this.assetReportId, assetsErrorWebhook.assetReportId) && Objects.equals(this.userId, assetsErrorWebhook.userId) && Objects.equals((Object)this.environment, (Object)assetsErrorWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.error, this.assetReportId, this.userId, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetsErrorWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    assetReportId: ").append(this.toIndentedString(this.assetReportId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

